/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.util.version;

import java.util.Arrays;

public class Version
implements Comparable<Version> {
    private final int[] numbers;
    private final String appendix;

    public Version(int ... numbers) {
        this(null, numbers);
    }

    public Version(String appendix, int ... numbers) {
        this.numbers = new int[numbers.length];
        System.arraycopy(numbers, 0, this.numbers, 0, numbers.length);
        this.appendix = appendix;
    }

    public int getNumber(int index) {
        if (index >= this.numbers.length) {
            return 0;
        }
        return this.numbers[index];
    }

    public int getMajor() {
        return this.getNumber(0);
    }

    public int getMinor() {
        return this.getNumber(1);
    }

    public int getRelease() {
        return this.getNumber(2);
    }

    public int getPatch() {
        return this.getNumber(3);
    }

    public String getAppendix() {
        return this.appendix;
    }

    public String toString() {
        StringBuilder versionString = new StringBuilder();
        for (int number : this.numbers) {
            if (versionString.length() > 0) {
                versionString.append('.');
            }
            versionString.append(number);
        }
        if (this.appendix != null) {
            versionString.append('-').append(this.appendix);
        }
        return versionString.toString();
    }

    public static Version parse(String versionString) {
        String[] componentStrings = versionString.split("\\.");
        int[] components = new int[componentStrings.length];
        String appendix = null;
        int index = -1;
        for (String componentString : componentStrings) {
            try {
                int dash;
                if (index == componentStrings.length - 2 && (dash = componentString.indexOf(45)) > -1) {
                    appendix = componentString.substring(dash + 1);
                    componentString = componentString.substring(0, dash);
                }
                components[++index] = Integer.parseInt(componentString);
            }
            catch (NumberFormatException nfe1) {
                return null;
            }
        }
        return new Version(appendix, components);
    }

    @Override
    public int compareTo(Version version) {
        int lengthDiff = this.numbers.length - version.numbers.length;
        for (int index = 0; index < Math.min(this.numbers.length, version.numbers.length); ++index) {
            int diff = this.numbers[index] - version.numbers[index];
            if (diff == 0) continue;
            return diff;
        }
        return lengthDiff;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Version)) {
            return false;
        }
        Version version = (Version)obj;
        return Arrays.equals(this.numbers, version.numbers);
    }

    public int hashCode() {
        return Arrays.hashCode(this.numbers);
    }
}

