/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.util.validation;

import java.util.ArrayList;
import java.util.List;
import net.pterodactylus.util.validation.AndValidator;
import net.pterodactylus.util.validation.DoubleRangeValidator;
import net.pterodactylus.util.validation.EqualityValidator;
import net.pterodactylus.util.validation.IdentityValidator;
import net.pterodactylus.util.validation.LongRangeValidator;
import net.pterodactylus.util.validation.NotNullValidator;
import net.pterodactylus.util.validation.NotValidator;
import net.pterodactylus.util.validation.OrValidator;
import net.pterodactylus.util.validation.SubClassValidator;
import net.pterodactylus.util.validation.Validator;

public class Validation {
    private List<ValidationRunner<?>> validationRunners = new ArrayList();

    private Validation() {
    }

    public static Validation begin() {
        return new Validation();
    }

    public Validation check() throws IllegalArgumentException {
        ArrayList<String> failedChecks = new ArrayList<String>();
        for (ValidationRunner<?> validationRunner : this.validationRunners) {
            if (validationRunner.validate()) continue;
            failedChecks.add(validationRunner.getObjectName() + " failed " + validationRunner.getValidator());
        }
        this.validationRunners.clear();
        if (failedChecks.isEmpty()) {
            return this;
        }
        StringBuilder message = new StringBuilder();
        message.append("Failed checks: ");
        for (String failedCheck : failedChecks) {
            message.append(failedCheck).append(", ");
        }
        message.setLength(message.length() - 2);
        message.append('.');
        failedChecks.clear();
        throw new IllegalArgumentException(message.toString());
    }

    public Validation is(String objectName, boolean value) {
        return this.isEqual(objectName, value, true);
    }

    public Validation isNot(String objectName, boolean value) {
        return this.isEqual(objectName, value, false);
    }

    public <T> Validation isNotNull(String objectName, T object) {
        this.validationRunners.add(new ValidationRunner<T>(objectName, object, new NotNullValidator()));
        return this;
    }

    public <T> Validation isNull(String objectName, T object) {
        this.validationRunners.add(new ValidationRunner<T>(objectName, object, new NotValidator(new NotNullValidator())));
        return this;
    }

    public <T> Validation isEither(String objectName, T object, T ... expecteds) {
        OrValidator<T> orValidator = new OrValidator<T>();
        for (T expected : expecteds) {
            orValidator.addValidator(new EqualityValidator<T>(expected));
        }
        this.validationRunners.add(new ValidationRunner<T>(objectName, object, orValidator));
        return this;
    }

    public <T> Validation isAll(String objectName, T object, T ... expecteds) {
        AndValidator<T> andValidator = new AndValidator<T>();
        for (T expected : expecteds) {
            andValidator.addValidator(new EqualityValidator<T>(expected));
        }
        this.validationRunners.add(new ValidationRunner<T>(objectName, object, andValidator));
        return this;
    }

    public Validation isLess(String objectName, long value, long upperBound) {
        this.validationRunners.add(new ValidationRunner<Long>(objectName, value, new LongRangeValidator(Long.MIN_VALUE, upperBound - 1L)));
        return this;
    }

    public Validation isLess(String objectName, double value, double upperBound) {
        this.validationRunners.add(new ValidationRunner<Double>(objectName, value, new DoubleRangeValidator(Double.NEGATIVE_INFINITY, false, upperBound, false)));
        return this;
    }

    public Validation isLessOrEqual(String objectName, long value, long upperBound) {
        this.validationRunners.add(new ValidationRunner<Long>(objectName, value, new LongRangeValidator(Long.MIN_VALUE, upperBound)));
        return this;
    }

    public Validation isLessOrEqual(String objectName, double value, double upperBound) {
        this.validationRunners.add(new ValidationRunner<Double>(objectName, value, new DoubleRangeValidator(Double.NEGATIVE_INFINITY, false, upperBound, true)));
        return this;
    }

    public <T> Validation isEqual(String objectName, T value, T expected) {
        this.validationRunners.add(new ValidationRunner<T>(objectName, value, new EqualityValidator<T>(expected)));
        return this;
    }

    public <T> Validation isSame(String objectName, T value, T expected) {
        this.validationRunners.add(new ValidationRunner<T>(objectName, value, new IdentityValidator<T>(expected)));
        return this;
    }

    public <T> Validation isNotEqual(String objectName, T value, T expected) {
        this.validationRunners.add(new ValidationRunner<T>(objectName, value, new NotValidator<T>(new EqualityValidator<T>(expected))));
        return this;
    }

    public Validation isGreater(String objectName, long value, long lowerBound) {
        this.validationRunners.add(new ValidationRunner<Long>(objectName, value, new LongRangeValidator(lowerBound + 1L, Long.MAX_VALUE)));
        return this;
    }

    public Validation isGreater(String objectName, double value, double lowerBound) {
        this.validationRunners.add(new ValidationRunner<Double>(objectName, value, new DoubleRangeValidator(lowerBound, false, Double.MAX_VALUE, true)));
        return this;
    }

    public Validation isGreaterOrEqual(String objectName, long value, long lowerBound) {
        this.validationRunners.add(new ValidationRunner<Long>(objectName, value, new LongRangeValidator(lowerBound, Long.MAX_VALUE)));
        return this;
    }

    public Validation isGreaterOrEqual(String objectName, double value, double lowerBound) {
        this.validationRunners.add(new ValidationRunner<Double>(objectName, value, new DoubleRangeValidator(lowerBound, true, Double.MAX_VALUE, true)));
        return this;
    }

    public Validation isPositive(String objectName, long value) {
        return this.isGreaterOrEqual(objectName, value, 0L);
    }

    public Validation isPositive(String objectName, double value) {
        return this.isGreaterOrEqual(objectName, value, 0.0);
    }

    public Validation isNegative(String objectName, long value) {
        return this.isLess(objectName, value, 0L);
    }

    public Validation isNegative(String objectName, double value) {
        return this.isLess(objectName, value, 0.0);
    }

    public Validation isInstanceOf(String objectName, Object object, Class<?> clazz) {
        this.validationRunners.add(new ValidationRunner<Object>(objectName, object, new SubClassValidator(clazz)));
        return this;
    }

    private static class ValidationRunner<T> {
        private final String objectName;
        private final T value;
        private final Validator<T> validator;

        public ValidationRunner(String objectName, T value, Validator<T> validator) {
            this.objectName = objectName;
            this.value = value;
            this.validator = validator;
        }

        public String getObjectName() {
            return this.objectName;
        }

        public Validator<T> getValidator() {
            return this.validator;
        }

        public boolean validate() {
            return this.validator.validate(this.value);
        }
    }
}

