/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.util.thread;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import net.pterodactylus.util.thread.DumpingThread;

public class DumpingThreadFactory
implements ThreadFactory {
    private static final AtomicInteger poolNumber = new AtomicInteger(0);
    private final AtomicInteger threadNumber = new AtomicInteger(0);
    private final String namePrefix;
    private final boolean createDaemonThreads;

    public DumpingThreadFactory() {
        this("DumpingThreadFactory-" + poolNumber.getAndIncrement() + "-Thread-");
    }

    public DumpingThreadFactory(String namePrefix) {
        this(namePrefix, true);
    }

    public DumpingThreadFactory(boolean createDaemonThreads) {
        this("DumpingThreadFactory-" + poolNumber.getAndIncrement() + "-Thread-", createDaemonThreads);
    }

    public DumpingThreadFactory(String namePrefix, boolean createDaemonThreads) {
        this.namePrefix = namePrefix;
        this.createDaemonThreads = createDaemonThreads;
    }

    @Override
    public Thread newThread(Runnable r) {
        DumpingThread thread2 = new DumpingThread(r);
        thread2.setDaemon(this.createDaemonThreads);
        thread2.setName(this.namePrefix + this.threadNumber.getAndIncrement());
        return thread2;
    }
}

