/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.util.template;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.pterodactylus.util.template.Accessor;
import net.pterodactylus.util.template.Filter;
import net.pterodactylus.util.template.Plugin;
import net.pterodactylus.util.template.TemplateContext;
import net.pterodactylus.util.template.TemplateProvider;

public class TemplateContextFactory {
    private static TemplateContextFactory instance;
    private final Map<String, Filter> filters = Collections.synchronizedMap(new HashMap());
    private final Map<String, Plugin> plugins = Collections.synchronizedMap(new HashMap());
    private final Map<Class<?>, Accessor> accessors = Collections.synchronizedMap(new HashMap());
    private List<TemplateProvider> templateProviders = Collections.synchronizedList(new ArrayList());
    private final Map<String, Object> templateObjects = Collections.synchronizedMap(new HashMap());

    public void addAccessor(Class<?> clazz, Accessor accessor) {
        this.accessors.put(clazz, accessor);
    }

    public void addFilter(String name, Filter filter2) {
        this.filters.put(name, filter2);
    }

    public void addPlugin(String name, Plugin plugin) {
        this.plugins.put(name, plugin);
    }

    public void addProvider(TemplateProvider templateProvider) {
        this.templateProviders.add(templateProvider);
    }

    public void addTemplateObject(String name, Object object) {
        this.templateObjects.put(name, object);
    }

    public static synchronized TemplateContextFactory getInstance() {
        if (instance == null) {
            instance = new TemplateContextFactory();
        }
        return instance;
    }

    public TemplateContext createTemplateContext() {
        TemplateContext templateContext = new TemplateContext();
        for (Map.Entry<String, Filter> entry : this.filters.entrySet()) {
            templateContext.addFilter(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, Object> entry : this.plugins.entrySet()) {
            templateContext.addPlugin(entry.getKey(), (Plugin)entry.getValue());
        }
        for (Map.Entry<Object, Object> entry : this.accessors.entrySet()) {
            templateContext.addAccessor((Class)entry.getKey(), (Accessor)entry.getValue());
        }
        for (TemplateProvider templateProvider : this.templateProviders) {
            templateContext.addTemplateProvider(templateProvider);
        }
        for (Map.Entry entry : this.templateObjects.entrySet()) {
            templateContext.set((String)entry.getKey(), entry.getValue());
        }
        return templateContext;
    }
}

