/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.util.template;

import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import net.pterodactylus.util.template.ContainerPart;
import net.pterodactylus.util.template.ReflectionAccessor;
import net.pterodactylus.util.template.TemplateContext;
import net.pterodactylus.util.template.TemplateException;
import net.pterodactylus.util.template.TemplateParser;

class LoopPart
extends ContainerPart {
    private static final ReflectionAccessor REFLECTION_ACCESSOR = new ReflectionAccessor();
    private final String collectionName;
    private final String itemName;
    private final String loopName;
    private final TemplateParser.Filters filters;

    public LoopPart(int line, int column, String collectionName, String itemName) {
        this(line, column, collectionName, itemName, "loop", new TemplateParser.Filters());
    }

    public LoopPart(int line, int column, String collectionName, String itemName, String loopName, TemplateParser.Filters filters) {
        super(line, column);
        this.collectionName = collectionName;
        this.itemName = itemName;
        this.loopName = loopName;
        this.filters = filters;
    }

    @Override
    public void render(TemplateContext templateContext, Writer writer) throws TemplateException {
        Collection collection;
        TemplateContext outerLoopContext = new TemplateContext(templateContext, true);
        Object collectionObject = this.filters.filter(this.getLine(), this.getColumn(), templateContext, templateContext.get(this.collectionName));
        if (collectionObject == null) {
            return;
        }
        if (collectionObject instanceof Collection) {
            collection = (Set)collectionObject;
            if (collection.isEmpty()) {
                return;
            }
        } else if (collectionObject instanceof Map) {
            Map map2 = (Map)collectionObject;
            collection = map2.entrySet();
        } else if (collectionObject instanceof Iterable) {
            collection = new ArrayList();
            for (Object object : (Iterable)collectionObject) {
                collection.add(object);
            }
        } else {
            collection = Arrays.asList(collectionObject);
        }
        LoopStructure loopStructure = new LoopStructure(collection.size());
        for (Map.Entry object : collection) {
            TemplateContext loopContext = new TemplateContext(outerLoopContext);
            loopContext.addAccessor(LoopStructure.class, REFLECTION_ACCESSOR);
            loopContext.set(this.loopName, loopStructure);
            loopContext.set(this.itemName, object);
            super.render(loopContext, writer);
            loopStructure.incCount();
        }
    }

    private static class LoopStructure {
        private final int size;
        private int count;

        public LoopStructure(int size) {
            this.size = size;
        }

        public int getSize() {
            return this.size;
        }

        public int getCount() {
            return this.count;
        }

        public void incCount() {
            ++this.count;
        }

        public boolean isFirst() {
            return this.count == 0;
        }

        public boolean isLast() {
            return this.count == this.size - 1;
        }

        public boolean isOdd() {
            return (this.count & 1) == 1;
        }

        public boolean isEven() {
            return (this.count & 1) == 0;
        }
    }
}

