/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.util.template;

import java.io.IOException;
import java.io.Writer;
import net.pterodactylus.util.io.Renderable;
import net.pterodactylus.util.template.AbstractPart;
import net.pterodactylus.util.template.TemplateContext;
import net.pterodactylus.util.template.TemplateException;
import net.pterodactylus.util.template.TemplateParser;

class FilteredTextPart
extends AbstractPart {
    private final String text;
    private final TemplateParser.Filters filters;

    public FilteredTextPart(int line, int column, String text, TemplateParser.Filters filters) {
        super(line, column);
        this.text = text;
        this.filters = filters;
    }

    @Override
    public void render(TemplateContext templateContext, Writer writer) throws TemplateException {
        Object data = this.filters.filter(this.getLine(), this.getColumn(), templateContext, this.text);
        try {
            if (data instanceof Renderable) {
                ((Renderable)data).render(writer);
            } else {
                writer.write(data != null ? String.valueOf(data) : "");
            }
        }
        catch (IOException ioe1) {
            throw new TemplateException(this.getLine(), this.getColumn(), "Can not render part.", ioe1);
        }
    }
}

