/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.util.template;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import net.pterodactylus.util.io.Closer;
import net.pterodactylus.util.template.Template;
import net.pterodactylus.util.template.TemplateContext;
import net.pterodactylus.util.template.TemplateParser;
import net.pterodactylus.util.template.TemplateProvider;

public class FilesystemTemplateProvider
implements TemplateProvider {
    public static final String SOURCE_PATH_OPTION = "FilesystemProviderSourcePath";
    private final String sourcePath;
    private final Map<String, Long> modificationTimes = new HashMap<String, Long>();
    private final Map<String, Template> templateCache = new HashMap<String, Template>();

    public FilesystemTemplateProvider(String sourcePath) {
        this.sourcePath = sourcePath;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Template getTemplate(TemplateContext templateContext, String templateName) {
        File templateFile;
        String sourcePath = this.sourcePath;
        if (templateContext.get(SOURCE_PATH_OPTION) != null) {
            sourcePath = String.valueOf(templateContext.get(SOURCE_PATH_OPTION));
        }
        if (!(templateFile = new File(sourcePath, templateName)).exists() || !templateFile.canRead()) {
            return null;
        }
        String templateFilename = templateFile.getAbsolutePath();
        long lastModificationTime = templateFile.lastModified();
        Map<String, Long> map2 = this.modificationTimes;
        synchronized (map2) {
            Template template;
            if (this.modificationTimes.containsKey(templateFilename) && this.modificationTimes.get(templateFilename) >= lastModificationTime) {
                return this.templateCache.get(templateFilename);
            }
            FileInputStream templateInputStream = null;
            InputStreamReader templateReader = null;
            try {
                templateInputStream = new FileInputStream(templateFile);
                templateReader = new InputStreamReader((InputStream)templateInputStream, "UTF-8");
                Template template2 = TemplateParser.parse(templateReader);
                this.modificationTimes.put(templateFilename, lastModificationTime);
                this.templateCache.put(templateFilename, template2);
                template = template2;
            }
            catch (FileNotFoundException fnfe1) {
                try {
                    throw new RuntimeException("Could not find template file!", fnfe1);
                    catch (UnsupportedEncodingException uee1) {
                        throw new RuntimeException("UTF-8 encoding unknown!", uee1);
                    }
                }
                catch (Throwable throwable) {
                    Closer.close(templateReader);
                    Closer.close(templateInputStream);
                    throw throwable;
                }
            }
            Closer.close(templateReader);
            Closer.close(templateInputStream);
            return template;
        }
    }
}

