/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.util.template;

import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.pterodactylus.util.cache.Cache;
import net.pterodactylus.util.cache.CacheException;
import net.pterodactylus.util.cache.CacheItem;
import net.pterodactylus.util.cache.DefaultCacheItem;
import net.pterodactylus.util.cache.MemoryCache;
import net.pterodactylus.util.cache.ValueRetriever;
import net.pterodactylus.util.logging.Logging;
import net.pterodactylus.util.template.Template;
import net.pterodactylus.util.template.TemplateContext;
import net.pterodactylus.util.template.TemplateException;
import net.pterodactylus.util.template.TemplateParser;
import net.pterodactylus.util.template.TemplateProvider;

public class ClassPathTemplateProvider
implements TemplateProvider {
    private static final Logger logger = Logging.getLogger(ClassPathTemplateProvider.class);
    private final Class<?> resourceClass;
    private final String resourcePath;
    private final Cache<String, Template> templateCache = new MemoryCache<String, Template>(new ValueRetriever<String, Template>(){

        @Override
        public CacheItem<Template> retrieve(String key) throws CacheException {
            Template template = ClassPathTemplateProvider.this.findTemplate(key);
            if (template != null) {
                return new DefaultCacheItem<Template>(template);
            }
            return null;
        }
    });

    public ClassPathTemplateProvider(Class<?> resourceClass) {
        this(resourceClass, "/");
    }

    public ClassPathTemplateProvider(Class<?> resourceClass, String resourcePath) {
        this.resourceClass = resourceClass;
        this.resourcePath = resourcePath;
    }

    @Override
    public Template getTemplate(TemplateContext templateContext, String templateName) {
        try {
            return this.templateCache.get(templateName);
        }
        catch (CacheException ce1) {
            logger.log(Level.WARNING, "Could not get template for " + templateName + "!", ce1);
            return null;
        }
    }

    private Template findTemplate(String templateName) {
        Reader templateReader = this.createReader(this.resourcePath + templateName);
        if (templateReader == null) {
            return null;
        }
        Template template = null;
        try {
            template = TemplateParser.parse(templateReader);
        }
        catch (TemplateException te1) {
            logger.log(Level.WARNING, "Could not parse template \u201c" + templateName + "\u201d for inclusion!", te1);
        }
        return template;
    }

    private Reader createReader(String resourceName) {
        try {
            return new InputStreamReader(this.resourceClass.getResourceAsStream(resourceName), "UTF-8");
        }
        catch (UnsupportedEncodingException uee1) {
            return null;
        }
    }
}

