/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.util.template;

import java.util.ArrayList;
import java.util.List;
import net.pterodactylus.util.template.Template;
import net.pterodactylus.util.template.TemplateContext;
import net.pterodactylus.util.template.TemplateProvider;

public class ChainingTemplateProvider
implements TemplateProvider {
    private final List<TemplateProvider> providers = new ArrayList<TemplateProvider>();

    public ChainingTemplateProvider(TemplateProvider ... providers) {
        for (TemplateProvider provider : providers) {
            this.providers.add(provider);
        }
    }

    @Override
    public Template getTemplate(TemplateContext templateContext, String templateName) {
        for (TemplateProvider provider : this.providers) {
            Template template = provider.getTemplate(templateContext, templateName);
            if (template == null) continue;
            return template;
        }
        return null;
    }
}

