/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.util.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListModel;
import net.pterodactylus.util.logging.Logging;

public class ToolTipList
extends JList {
    private static final Logger logger = Logging.getLogger(ToolTipList.class);
    private final ListModel listModel;

    public ToolTipList(ListModel listModel) {
        super(listModel);
        this.listModel = listModel;
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        logger.log(Level.FINEST, "Getting Tooltip for " + event + "\u2026");
        int row = this.locationToIndex(event.getPoint());
        logger.log(Level.FINEST, "Mouse is over row " + row + ".");
        if (row < 0) {
            return null;
        }
        Object value = this.listModel.getElementAt(row);
        logger.log(Level.FINEST, "Getting Tooltip for \u201c" + value + "\u201d\u2026");
        if (value == null) {
            return null;
        }
        Component cell = this.getCellRenderer().getListCellRendererComponent(this, value, row, false, false);
        logger.log(Level.FINEST, "CellRenderer gave us Cell " + cell + ".");
        if (cell == null) {
            return null;
        }
        int cellX = cell.getX();
        int cellY = cell.getY();
        cell.setSize(new Dimension(-cellX, -cellY));
        cell.setLocation(0, 0);
        Point cellLocation = this.indexToLocation(row);
        Point mousePosition = event.getPoint();
        mousePosition.translate(-((int)cellLocation.getX()), -((int)cellLocation.getY()));
        logger.log(Level.FINEST, "Mouse Position translates to " + mousePosition + ".");
        Component toolTipComponent = cell.getComponentAt(mousePosition);
        cell.setLocation(cellX, cellY);
        logger.log(Level.FINEST, "Component under Mouse is " + toolTipComponent + ".");
        if (toolTipComponent instanceof JComponent) {
            return ((JComponent)toolTipComponent).getToolTipText();
        }
        return null;
    }
}

