/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.util.swing;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;

public class SwingUtils {
    public static void center(Window window) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension windowSize = window.getSize();
        window.setLocation((screenSize.width - windowSize.width) / 2, (screenSize.height - windowSize.height) / 2);
    }

    public static void center(Window window, Window ownerWindow) {
        Point ownerWindowLocation = ownerWindow.getLocation();
        Dimension ownerWindowDimension = ownerWindow.getSize();
        Dimension windowSize = window.getSize();
        window.setLocation(ownerWindowLocation.x + (ownerWindowDimension.width - windowSize.width) / 2, ownerWindowLocation.y + (ownerWindowDimension.height - windowSize.height) / 2);
    }

    public static void repackCentered(Window window) {
        Point center = SwingUtils.getCenter(window.getBounds());
        window.pack();
        window.setLocation(center.x - window.getWidth() / 2, center.y - window.getHeight() / 2);
        window.repaint();
    }

    private static Point getCenter(Rectangle bounds) {
        return new Point(bounds.x + bounds.width / 2, bounds.y + bounds.height / 2);
    }
}

