/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.util.swing;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class ListModelList<E>
implements ListModel,
List<E> {
    private final List<E> wrappedList;
    private final List<ListDataListener> listDataListeners = new CopyOnWriteArrayList<ListDataListener>();

    public ListModelList(List<E> originalList) {
        this.wrappedList = originalList;
    }

    @Override
    public void addListDataListener(ListDataListener listDataListener) {
        this.listDataListeners.add(listDataListener);
    }

    @Override
    public E getElementAt(int index) {
        return this.wrappedList.get(index);
    }

    @Override
    public int getSize() {
        return this.wrappedList.size();
    }

    @Override
    public void removeListDataListener(ListDataListener listDataListener) {
        this.listDataListeners.remove(listDataListener);
    }

    @Override
    public boolean add(E element) {
        boolean added = this.wrappedList.add(element);
        int position = this.wrappedList.size() - 1;
        ListDataEvent listDataEvent = new ListDataEvent(this, 1, position, position);
        for (ListDataListener listDataListener : this.listDataListeners) {
            listDataListener.intervalAdded(listDataEvent);
        }
        return added;
    }

    @Override
    public void add(int index, E element) {
        this.wrappedList.add(element);
        ListDataEvent listDataEvent = new ListDataEvent(this, 1, index, index);
        for (ListDataListener listDataListener : this.listDataListeners) {
            listDataListener.intervalAdded(listDataEvent);
        }
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        int firstPosition = this.wrappedList.size();
        boolean changed = this.wrappedList.addAll(collection);
        if (changed) {
            ListDataEvent listDataEvent = new ListDataEvent(this, 1, firstPosition, this.wrappedList.size() - 1);
            for (ListDataListener listDataListener : this.listDataListeners) {
                listDataListener.intervalAdded(listDataEvent);
            }
        }
        return changed;
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> collection) {
        boolean changed = this.wrappedList.addAll(collection);
        if (changed) {
            ListDataEvent listDataEvent = new ListDataEvent(this, 1, index, index + collection.size() - 1);
            for (ListDataListener listDataListener : this.listDataListeners) {
                listDataListener.intervalAdded(listDataEvent);
            }
        }
        return changed;
    }

    @Override
    public void clear() {
        if (!this.wrappedList.isEmpty()) {
            int size = this.wrappedList.size();
            this.wrappedList.clear();
            ListDataEvent listDataEvent = new ListDataEvent(this, 2, 0, size - 1);
            for (ListDataListener listDataListener : this.listDataListeners) {
                listDataListener.intervalRemoved(listDataEvent);
            }
        }
    }

    @Override
    public boolean contains(Object object) {
        return this.wrappedList.contains(object);
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return this.wrappedList.containsAll(collection);
    }

    @Override
    public E get(int index) {
        return this.wrappedList.get(index);
    }

    @Override
    public int indexOf(Object object) {
        return this.wrappedList.indexOf(object);
    }

    @Override
    public boolean isEmpty() {
        return this.wrappedList.isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        return this.wrappedList.iterator();
    }

    @Override
    public int lastIndexOf(Object object) {
        return this.wrappedList.lastIndexOf(object);
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.wrappedList.listIterator();
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return this.wrappedList.listIterator(index);
    }

    @Override
    public boolean remove(Object object) {
        int index = this.wrappedList.indexOf(object);
        if (index != -1) {
            this.wrappedList.remove(object);
            ListDataEvent listDataEvent = new ListDataEvent(this, 2, index, index);
            for (ListDataListener listDataListener : this.listDataListeners) {
                listDataListener.intervalRemoved(listDataEvent);
            }
            return true;
        }
        return false;
    }

    @Override
    public E remove(int index) {
        E removedElement = this.wrappedList.remove(index);
        ListDataEvent listDataEvent = new ListDataEvent(this, 2, index, index);
        for (ListDataListener listDataListener : this.listDataListeners) {
            listDataListener.intervalRemoved(listDataEvent);
        }
        return removedElement;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        int lowestPosition = Integer.MAX_VALUE;
        int highestPosition = Integer.MIN_VALUE;
        for (Object element : collection) {
            int position = this.wrappedList.indexOf(element);
            if (position == -1) continue;
            if (position < lowestPosition) {
                lowestPosition = position;
            }
            if (position <= highestPosition) continue;
            highestPosition = position;
        }
        if (lowestPosition < Integer.MAX_VALUE) {
            for (Object element : collection) {
                this.wrappedList.remove(element);
            }
            ListDataEvent listDataEvent = new ListDataEvent(this, 0, lowestPosition, highestPosition);
            for (ListDataListener listDataListener : this.listDataListeners) {
                listDataListener.contentsChanged(listDataEvent);
            }
        }
        return lowestPosition < Integer.MAX_VALUE;
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        int size = this.wrappedList.size();
        boolean changed = this.wrappedList.retainAll(collection);
        ListDataEvent listDataEvent = new ListDataEvent(this, 0, 0, size - 1);
        for (ListDataListener listDataListener : this.listDataListeners) {
            listDataListener.contentsChanged(listDataEvent);
        }
        return changed;
    }

    @Override
    public E set(int index, E element) {
        E oldElement = this.wrappedList.set(index, element);
        ListDataEvent listDataEvent = new ListDataEvent(this, 0, index, index);
        for (ListDataListener listDataListener : this.listDataListeners) {
            listDataListener.contentsChanged(listDataEvent);
        }
        return oldElement;
    }

    @Override
    public int size() {
        return this.wrappedList.size();
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        return this.wrappedList.subList(fromIndex, toIndex);
    }

    @Override
    public Object[] toArray() {
        return this.wrappedList.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.wrappedList.toArray(a);
    }
}

