/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.util.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import net.pterodactylus.util.io.Closer;
import net.pterodactylus.util.io.StreamCopier;

public class TemporaryInputStream
extends FilterInputStream {
    private static final Map<InputStream, File> streamFiles = new HashMap<InputStream, File>();
    private static final Map<File, Integer> fileCounts = new HashMap<File, Integer>();

    public TemporaryInputStream(InputStream sourceInputStream) throws IOException {
        super(TemporaryInputStream.createFileInputStream(sourceInputStream));
    }

    private TemporaryInputStream(File tempFile) throws FileNotFoundException {
        super(new FileInputStream(tempFile));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        super.close();
        Map<File, Integer> map2 = fileCounts;
        synchronized (map2) {
            File tempFile = streamFiles.remove(this.in);
            if (tempFile != null) {
                if (fileCounts.get(tempFile) > 0) {
                    fileCounts.put(tempFile, fileCounts.get(tempFile) - 1);
                } else {
                    fileCounts.remove(tempFile);
                    tempFile.delete();
                }
            }
        }
    }

    public InputStream reopen() throws IOException {
        Map<File, Integer> map2 = fileCounts;
        synchronized (map2) {
            File tempFile = streamFiles.get(this.in);
            if (tempFile != null) {
                fileCounts.put(tempFile, fileCounts.get(tempFile) + 1);
                return new TemporaryInputStream(tempFile);
            }
            throw new FileNotFoundException("Temporary file has already disappeared.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static InputStream createFileInputStream(InputStream sourceInputStream) throws IOException {
        File tempFile = File.createTempFile("utils-temp-", ".tmp");
        tempFile.deleteOnExit();
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(tempFile);
            StreamCopier.copy(sourceInputStream, fileOutputStream);
        }
        catch (IOException ioe1) {
            try {
                throw ioe1;
            }
            catch (Throwable throwable) {
                Closer.close(fileOutputStream);
                throw throwable;
            }
        }
        Closer.close(fileOutputStream);
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(tempFile);
            streamFiles.put(fileInputStream, tempFile);
            Map<File, Integer> map2 = fileCounts;
            synchronized (map2) {
                fileCounts.put(tempFile, 0);
            }
            return fileInputStream;
        }
        catch (IOException ioe1) {
            Closer.close(fileInputStream);
            tempFile.delete();
            throw ioe1;
        }
    }
}

