/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.util.io;

import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.ServerSocket;
import java.net.Socket;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.pterodactylus.util.logging.Logging;

public class Closer {
    private static final Logger logger = Logging.getLogger(Closer.class.getName());

    public static void close(ResultSet resultSet) {
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public static void close(Statement statement) {
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public static void close(Connection connection) {
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public static void close(ServerSocket serverSocket) {
        if (serverSocket != null) {
            try {
                serverSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void close(Socket socket) {
        if (socket != null) {
            try {
                socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void close(InputStream inputStream) {
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void close(OutputStream outputStream) {
        if (outputStream != null) {
            Closer.flush(outputStream);
            try {
                outputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void close(Reader reader) {
        if (reader != null) {
            try {
                reader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void close(Writer writer) {
        if (writer != null) {
            Closer.flush(writer);
            try {
                writer.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void close(JarFile jarFile) {
        if (jarFile != null) {
            try {
                jarFile.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void close(Closeable closeable) {
        if (closeable == null) {
            return;
        }
        Closer.flush(closeable);
        try {
            closeable.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void close(Object object) {
        Closer.flush(object);
        if (object == null) {
            return;
        }
        try {
            Method closeMethod = object.getClass().getMethod("close", new Class[0]);
            closeMethod.invoke(object, new Object[0]);
        }
        catch (SecurityException se1) {
            logger.log(Level.WARNING, "Could not call close() method on " + object, se1);
        }
        catch (NoSuchMethodException se1) {
        }
        catch (IllegalArgumentException iae1) {
            logger.log(Level.WARNING, "Illegal argument for close() method on " + object, iae1);
        }
        catch (IllegalAccessException iae1) {
            logger.log(Level.WARNING, "Could not call close() method on " + object, iae1);
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
    }

    public static void flush(Flushable flushable) {
        if (flushable != null) {
            try {
                flushable.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void flush(Object object) {
        if (object == null) {
            return;
        }
        try {
            Method flushMethod = object.getClass().getMethod("flush", new Class[0]);
            flushMethod.invoke(object, new Object[0]);
        }
        catch (SecurityException se1) {
            logger.log(Level.WARNING, "Could not call flush() method on " + object, se1);
        }
        catch (NoSuchMethodException se1) {
        }
        catch (IllegalArgumentException iae1) {
            logger.log(Level.WARNING, "Illegal argument for flush() method on " + object, iae1);
        }
        catch (IllegalAccessException iae1) {
            logger.log(Level.WARNING, "Could not call flush() method on " + object, iae1);
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
    }
}

