/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.util.database;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.pterodactylus.util.database.Parameter;
import net.pterodactylus.util.database.WhereClause;

public class AndWhereClause
implements WhereClause {
    private final List<WhereClause> whereClauses = new ArrayList<WhereClause>();

    public AndWhereClause() {
    }

    public AndWhereClause(WhereClause ... whereClauses) {
        for (WhereClause whereClause : whereClauses) {
            this.whereClauses.add(whereClause);
        }
    }

    public AndWhereClause(Collection<WhereClause> whereClauses) {
        this.whereClauses.addAll(whereClauses);
    }

    public AndWhereClause add(WhereClause whereClause) {
        this.whereClauses.add(whereClause);
        return this;
    }

    @Override
    public List<Parameter<?>> getParameters() {
        ArrayList parameters2 = new ArrayList();
        for (WhereClause whereClause : this.whereClauses) {
            parameters2.addAll(whereClause.getParameters());
        }
        return parameters2;
    }

    @Override
    public void render(Writer writer) throws IOException {
        if (this.whereClauses.isEmpty()) {
            writer.write("(1 = 1)");
        }
        boolean first2 = true;
        for (WhereClause whereClause : this.whereClauses) {
            if (!first2) {
                writer.write(" AND ");
            }
            writer.write("(");
            whereClause.render(writer);
            writer.write(")");
            first2 = false;
        }
    }
}

