/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.util.data;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import net.pterodactylus.util.data.Node;

class DefaultNode<E extends Comparable<E>>
implements Node<E> {
    private final Node<E> parentNode;
    private final E element;
    private final List<Node<E>> children = new ArrayList<Node<E>>();

    DefaultNode() {
        this.parentNode = null;
        this.element = null;
    }

    DefaultNode(Node<E> parentNode, E element) {
        if (parentNode == null || element == null) {
            throw new NullPointerException("null is not allowed as parent or element");
        }
        this.parentNode = parentNode;
        this.element = element;
    }

    @Override
    public Node<E> getParent() {
        return this.parentNode;
    }

    @Override
    public E getElement() {
        return this.element;
    }

    @Override
    public Node<E> addChild(E child) {
        DefaultNode<E> childNode = new DefaultNode<E>(this, child);
        this.children.add(childNode);
        return childNode;
    }

    @Override
    public int size() {
        return this.children.size();
    }

    @Override
    public Node<E> getChild(int childIndex) {
        return this.children.get(childIndex);
    }

    @Override
    public Node<E> getChild(E element) {
        for (Node<E> childNode : this.children) {
            if (!childNode.getElement().equals(element)) continue;
            return childNode;
        }
        return null;
    }

    @Override
    public boolean hasChild(Node<E> childNode) {
        return this.children.contains(childNode);
    }

    @Override
    public boolean hasChild(E element) {
        for (Node<E> childNode : this.children) {
            if (!childNode.getElement().equals(element)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getIndexOfChild(Node<E> childNode) {
        int childIndex = 0;
        for (Node<E> node : this.children) {
            if (node.equals(childNode)) {
                return childIndex;
            }
            ++childIndex;
        }
        return -1;
    }

    @Override
    public int getIndexOfChild(E element) {
        int childIndex = 0;
        for (Node<E> node : this.children) {
            if (node.getElement().equals(element)) {
                return childIndex;
            }
            ++childIndex;
        }
        return -1;
    }

    @Override
    public void removeChild(Node<E> childNode) {
        this.children.remove(childNode);
    }

    @Override
    public void removeChild(E child) {
        for (Node<E> childNode : this.children) {
            if (!child.equals(childNode.getElement())) continue;
            this.children.remove(childNode);
            break;
        }
    }

    @Override
    public void removeChild(int childIndex) {
        this.children.remove(childIndex);
    }

    @Override
    public void removeAllChildren() {
        this.children.clear();
    }

    @Override
    public Iterator<Node<E>> iterator() {
        return this.children.iterator();
    }

    @Override
    public Node<E> findChild(E element) {
        for (Node<E> childNode : this.children) {
            Node<E> wantedNode = childNode.findChild(element);
            if (wantedNode == null) continue;
            return wantedNode;
        }
        if (this.element.equals(element)) {
            return this;
        }
        return null;
    }

    @Override
    public void sortChildren() {
        Collections.sort(this.children);
    }

    @Override
    public void sortChildren(Comparator<Node<E>> comparator) {
        Collections.sort(this.children, comparator);
    }

    @Override
    public int compareTo(Node<E> otherNode) {
        return this.element.compareTo(otherNode.getElement());
    }
}

