/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.util.config;

import net.pterodactylus.util.config.AbstractValue;
import net.pterodactylus.util.config.Configuration;
import net.pterodactylus.util.config.ConfigurationException;
import net.pterodactylus.util.config.ExtendedConfigurationBackend;

public class BooleanValue
extends AbstractValue<Boolean> {
    public BooleanValue(Configuration configuration, String attribute) {
        super(configuration, attribute);
    }

    @Override
    public Boolean getValue() throws ConfigurationException {
        if (this.configuration.configurationBackend instanceof ExtendedConfigurationBackend) {
            return ((ExtendedConfigurationBackend)this.configuration.configurationBackend).getBooleanValue(this.attribute);
        }
        String value = this.configuration.configurationBackend.getValue(this.attribute);
        if (value == null) {
            return null;
        }
        return "true".equalsIgnoreCase(value) || "yes".equalsIgnoreCase(value) || "1".equalsIgnoreCase(value) || "on".equalsIgnoreCase(value);
    }

    @Override
    public Boolean getValue(Boolean defaultValue) {
        try {
            if (this.configuration.configurationBackend instanceof ExtendedConfigurationBackend) {
                return ((ExtendedConfigurationBackend)this.configuration.configurationBackend).getBooleanValue(this.attribute);
            }
            String value = this.configuration.configurationBackend.getValue(this.attribute);
            if (value == null) {
                return defaultValue;
            }
            return "true".equalsIgnoreCase(value) || "yes".equalsIgnoreCase(value) || "1".equalsIgnoreCase(value) || "on".equalsIgnoreCase(value);
        }
        catch (ConfigurationException ce1) {
            return defaultValue;
        }
    }

    @Override
    public void setValue(Boolean newValue) throws ConfigurationException {
        if (this.configuration.configurationBackend instanceof ExtendedConfigurationBackend) {
            ((ExtendedConfigurationBackend)this.configuration.configurationBackend).setBooleanValue(this.attribute, newValue);
        }
        this.configuration.configurationBackend.putValue(this.attribute, newValue != null ? String.valueOf(newValue) : null);
    }
}

