/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.util.collection;

import java.util.Iterator;
import java.util.List;

public class Pagination<T>
implements Iterable<T> {
    private final List<T> list;
    private int pageSize;
    private int page;
    private int pageCount;

    public Pagination(List<T> list, int pageSize) {
        this.list = list;
        this.pageSize = pageSize;
        this.pageCount = (list.size() - 1) / pageSize + 1;
    }

    public int getPage() {
        return this.page;
    }

    public int getPageNumber() {
        return this.page + 1;
    }

    public Pagination<T> setPage(int page) {
        this.page = page < 0 ? 0 : (page >= this.pageCount ? this.pageCount - 1 : page);
        return this;
    }

    public int getPageCount() {
        return this.pageCount;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public Pagination<T> setPageSize(int pageSize) {
        int newPageSize = pageSize < 1 ? 1 : pageSize;
        int index = this.page * this.pageSize;
        this.pageSize = newPageSize;
        this.pageCount = (this.list.size() - 1) / newPageSize + 1;
        this.page = index / newPageSize;
        return this;
    }

    public int getItemCount() {
        return Math.min(this.pageSize, this.list.size() - this.page * this.pageSize);
    }

    public List<T> getItems() {
        return this.list.subList(this.page * this.pageSize, this.page * this.pageSize + this.getItemCount());
    }

    public boolean isFirst() {
        return this.page == 0;
    }

    public boolean isLast() {
        return this.page == this.pageCount - 1;
    }

    public boolean isNecessary() {
        return this.pageCount > 1;
    }

    public int getPreviousPage() {
        return this.page - 1;
    }

    public int getNextPage() {
        return this.page + 1;
    }

    public int getLastPage() {
        return this.pageCount - 1;
    }

    @Override
    public Iterator<T> iterator() {
        return this.getItems().iterator();
    }
}

