/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.util.collection;

import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class Iterators {
    public static <T> Iterator<T> fromArray(final T[] elements) {
        return new Iterator<T>(){
            private int currentIndex = 0;

            @Override
            public boolean hasNext() {
                return this.currentIndex < elements.length;
            }

            @Override
            public T next() {
                if (this.currentIndex < elements.length) {
                    return elements[this.currentIndex++];
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
            }
        };
    }

    public static <T> Iterator<T> fromEnumeration(final Enumeration<T> enumeration) {
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return enumeration.hasMoreElements();
            }

            @Override
            public T next() {
                return enumeration.nextElement();
            }

            @Override
            public void remove() {
            }
        };
    }
}

