/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.util.collection;

import java.util.Iterator;
import net.pterodactylus.util.collection.filter.Filter;
import net.pterodactylus.util.collection.filter.FilteredIterator;
import net.pterodactylus.util.collection.mapper.MappedIterator;
import net.pterodactylus.util.collection.mapper.Mapper;
import net.pterodactylus.util.collection.processor.ProcessedIterator;
import net.pterodactylus.util.collection.processor.Processor;

public class IteratorWrapper<T>
implements Iterator<T> {
    private final Iterator<T> iterator;

    public IteratorWrapper(Iterator<T> iterator2) {
        this.iterator = iterator2;
    }

    public IteratorWrapper<T> filter(Filter<? super T> filter2) {
        return new IteratorWrapper<T>(new FilteredIterator<T>(this.iterator, filter2));
    }

    public <O> IteratorWrapper<O> map(Mapper<? super T, ? extends O> mapper) {
        return new IteratorWrapper<T>(new MappedIterator<T, O>(this.iterator, mapper));
    }

    public IteratorWrapper<T> process(Processor<? super T> processor) {
        return new IteratorWrapper<T>(new ProcessedIterator<T>(this.iterator, processor));
    }

    public static <T> IteratorWrapper<T> wrap(Iterator<T> iterator2) {
        return new IteratorWrapper<T>(iterator2);
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public T next() {
        return this.iterator.next();
    }

    @Override
    public void remove() {
        this.iterator.remove();
    }
}

