/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.util.collection;

import net.pterodactylus.util.validation.Validation;

public class Arrays {
    public static byte[] merge(byte[] first2, byte[] second) throws IllegalArgumentException {
        Validation.begin().isNotNull("First Array", first2).isNotNull("Second Array", second).check().isLessOrEqual("Combined Length", (long)first2.length + (long)second.length, Integer.MAX_VALUE).check();
        if (first2.length == 0) {
            return second;
        }
        if (second.length == 0) {
            return first2;
        }
        byte[] result2 = new byte[first2.length + second.length];
        System.arraycopy(first2, 0, result2, 0, first2.length);
        System.arraycopy(second, 0, result2, first2.length, second.length);
        return result2;
    }
}

