/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.util.collection;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ArrayMap<K, V>
implements Map<K, V> {
    private Object[] keys;
    private Object[] values;
    private int size = 0;

    public ArrayMap() {
        this(10);
    }

    public ArrayMap(int initialSize) {
        this.keys = new Object[initialSize];
        this.values = new Object[initialSize];
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.locateKey(key) != -1;
    }

    @Override
    public boolean containsValue(Object value) {
        return this.locateValue(value) != -1;
    }

    @Override
    public V get(Object key) {
        int index = this.locateKey(key);
        if (index == -1) {
            return null;
        }
        return (V)this.values[index];
    }

    @Override
    public V put(K key, V value) {
        int index = this.locateKey(key);
        if (index == -1) {
            this.checkResize();
            this.keys[this.size] = key;
            this.values[this.size] = value;
            ++this.size;
            return null;
        }
        Object oldValue = this.values[index];
        this.values[index] = value;
        return (V)oldValue;
    }

    @Override
    public V remove(Object key) {
        int index = this.locateKey(key);
        if (index == -1) {
            return null;
        }
        Object value = this.values[index];
        if (index < this.size - 1) {
            this.keys[index] = this.keys[this.size - 1];
            this.values[index] = this.values[this.size - 1];
        }
        --this.size;
        return (V)value;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map2) {
        for (Map.Entry<K, V> entry : map2.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        this.size = 0;
    }

    @Override
    public Set<K> keySet() {
        if (this.size < this.keys.length) {
            Object[] temp = new Object[this.size];
            System.arraycopy(this.keys, 0, temp, 0, this.size);
            return new HashSet<Object>(Arrays.asList(temp));
        }
        return new HashSet<Object>(Arrays.asList(this.keys));
    }

    @Override
    public Collection<V> values() {
        if (this.size < this.keys.length) {
            Object[] temp = new Object[this.size];
            System.arraycopy(this.values, 0, temp, 0, this.size);
            return Arrays.asList(temp);
        }
        return Arrays.asList(this.values);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        HashSet<Map.Entry<K, V>> entries = new HashSet<Map.Entry<K, V>>();
        for (int index = 0; index < this.size; ++index) {
            final Object key = this.keys[index];
            final Object value = this.values[index];
            entries.add(new Map.Entry<K, V>(){

                @Override
                public K getKey() {
                    return key;
                }

                @Override
                public V getValue() {
                    return value;
                }

                @Override
                public V setValue(V value2) {
                    return value2;
                }
            });
        }
        return entries;
    }

    private int locateKey(Object key) {
        return this.locateObject(this.keys, key);
    }

    private int locateValue(Object value) {
        return this.locateObject(this.values, value);
    }

    private int locateObject(Object[] data, Object value) {
        for (int index = 0; index < this.size; ++index) {
            if ((value != null || data[index] != null) && (value == null || !value.equals(data[index]))) continue;
            return index;
        }
        return -1;
    }

    private void checkResize() {
        if (this.size == this.keys.length) {
            Object[] newKeys = new Object[this.keys.length * 2];
            Object[] newValues = new Object[this.keys.length * 2];
            System.arraycopy(this.keys, 0, newKeys, 0, this.size);
            System.arraycopy(this.values, 0, newValues, 0, this.size);
            this.keys = newKeys;
            this.values = newValues;
        }
    }
}

