/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.sone.web.pages;

import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.pterodactylus.sone.data.Post;
import net.pterodactylus.sone.data.Sone;
import net.pterodactylus.sone.main.Loaders;
import net.pterodactylus.sone.utils.RequestsKt;
import net.pterodactylus.sone.web.WebInterface;
import net.pterodactylus.sone.web.page.SoneRequest;
import net.pterodactylus.sone.web.page.TemplatePath;
import net.pterodactylus.sone.web.page.TemplateRenderer;
import net.pterodactylus.sone.web.page.ToadletPath;
import net.pterodactylus.sone.web.pages.LoggedInPage;
import net.pterodactylus.util.template.TemplateContext;
import org.jetbrains.annotations.NotNull;

@TemplatePath(value="/templates/deletePost.html")
@ToadletPath(value="deletePost.html")
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u001f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014\u00a8\u0006\u0011"}, d2={"Lnet/pterodactylus/sone/web/pages/DeletePostPage;", "Lnet/pterodactylus/sone/web/pages/LoggedInPage;", "webInterface", "Lnet/pterodactylus/sone/web/WebInterface;", "loaders", "Lnet/pterodactylus/sone/main/Loaders;", "templateRenderer", "Lnet/pterodactylus/sone/web/page/TemplateRenderer;", "(Lnet/pterodactylus/sone/web/WebInterface;Lnet/pterodactylus/sone/main/Loaders;Lnet/pterodactylus/sone/web/page/TemplateRenderer;)V", "handleRequest", "", "soneRequest", "Lnet/pterodactylus/sone/web/page/SoneRequest;", "currentSone", "Lnet/pterodactylus/sone/data/Sone;", "templateContext", "Lnet/pterodactylus/util/template/TemplateContext;", "Sone"})
public final class DeletePostPage
extends LoggedInPage {
    @Override
    protected void handleRequest(@NotNull SoneRequest soneRequest, @NotNull Sone currentSone, @NotNull TemplateContext templateContext) {
        Intrinsics.checkParameterIsNotNull(soneRequest, "soneRequest");
        Intrinsics.checkParameterIsNotNull(currentSone, "currentSone");
        Intrinsics.checkParameterIsNotNull(templateContext, "templateContext");
        if (RequestsKt.isPOST(soneRequest)) {
            Post post = soneRequest.getCore().getPost(soneRequest.getHttpRequest().getPartAsStringFailsafe("post", 36));
            if (post == null) {
                Void void_ = this.redirectTo("noPermission.html");
                throw null;
            }
            Intrinsics.checkExpressionValueIsNotNull(post, "soneRequest.core.getPost\u2026ctTo(\"noPermission.html\")");
            Post post2 = post;
            String returnPage = soneRequest.getHttpRequest().getPartAsStringFailsafe("returnPage", 256);
            Sone sone = post2.getSone();
            Intrinsics.checkExpressionValueIsNotNull(sone, "post.sone");
            if (!sone.isLocal()) {
                Void void_ = this.redirectTo("noPermission.html");
                throw null;
            }
            if (soneRequest.getHttpRequest().isPartSet("confirmDelete")) {
                soneRequest.getCore().deletePost(post2);
                Void void_ = this.redirectTo(returnPage);
                throw null;
            }
            if (soneRequest.getHttpRequest().isPartSet("abortDelete")) {
                Void void_ = this.redirectTo(returnPage);
                throw null;
            }
            templateContext.set("post", post2);
            templateContext.set("returnPage", returnPage);
            return;
        }
        Post post = soneRequest.getCore().getPost(soneRequest.getHttpRequest().getParam("post"));
        if (post == null) {
            Void void_ = this.redirectTo("noPermission.html");
            throw null;
        }
        templateContext.set("post", post);
        templateContext.set("returnPage", soneRequest.getHttpRequest().getParam("returnPage"));
    }

    @Inject
    public DeletePostPage(@NotNull WebInterface webInterface, @NotNull Loaders loaders, @NotNull TemplateRenderer templateRenderer) {
        Intrinsics.checkParameterIsNotNull(webInterface, "webInterface");
        Intrinsics.checkParameterIsNotNull(loaders, "loaders");
        Intrinsics.checkParameterIsNotNull(templateRenderer, "templateRenderer");
        super("Page.DeletePost.Title", webInterface, loaders, templateRenderer);
    }
}

