/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.sone.web.page;

import freenet.client.HighLevelSimpleClient;
import freenet.clients.http.LinkEnabledCallback;
import freenet.clients.http.LinkFilterExceptedToadlet;
import freenet.clients.http.Toadlet;
import freenet.clients.http.ToadletContext;
import freenet.support.MultiValueTable;
import freenet.support.api.Bucket;
import freenet.support.api.HTTPRequest;
import freenet.support.api.RandomAccessBucket;
import java.io.Closeable;
import java.io.OutputStream;
import java.net.URI;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.pterodactylus.sone.utils.BucketsKt;
import net.pterodactylus.sone.web.page.FreenetPage;
import net.pterodactylus.sone.web.page.FreenetRequest;
import net.pterodactylus.util.web.Header;
import net.pterodactylus.util.web.Method;
import net.pterodactylus.util.web.Page;
import net.pterodactylus.util.web.Request;
import net.pterodactylus.util.web.Response;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B-\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0010\u000b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\fJ \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J$\u0010\u0017\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016J\u0010\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\nH\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u0012H\u0016J\b\u0010\u001e\u001a\u00020\u0007H\u0016J\b\u0010\u001f\u001a\u00020\u0007H\u0016R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lnet/pterodactylus/sone/web/page/PageToadlet;", "Lfreenet/clients/http/Toadlet;", "Lfreenet/clients/http/LinkEnabledCallback;", "Lfreenet/clients/http/LinkFilterExceptedToadlet;", "highLevelSimpleClient", "Lfreenet/client/HighLevelSimpleClient;", "menuName", "", "page", "Lnet/pterodactylus/util/web/Page;", "Lnet/pterodactylus/sone/web/page/FreenetRequest;", "pathPrefix", "(Lfreenet/client/HighLevelSimpleClient;Ljava/lang/String;Lnet/pterodactylus/util/web/Page;Ljava/lang/String;)V", "getMenuName", "()Ljava/lang/String;", "handleMethodGET", "", "uri", "Ljava/net/URI;", "httpRequest", "Lfreenet/support/api/HTTPRequest;", "toadletContext", "Lfreenet/clients/http/ToadletContext;", "handleMethodPOST", "handleRequest", "pageRequest", "isEnabled", "", "isLinkExcepted", "link", "path", "toString", "Sone"})
public final class PageToadlet
extends Toadlet
implements LinkEnabledCallback,
LinkFilterExceptedToadlet {
    @Nullable
    private final String menuName;
    private final Page<FreenetRequest> page;
    private final String pathPrefix;

    @NotNull
    public String path() {
        return this.pathPrefix + this.page.getPath();
    }

    public void handleMethodGET(@NotNull URI uri, @NotNull HTTPRequest httpRequest, @NotNull ToadletContext toadletContext) {
        Intrinsics.checkParameterIsNotNull(uri, "uri");
        Intrinsics.checkParameterIsNotNull(httpRequest, "httpRequest");
        Intrinsics.checkParameterIsNotNull(toadletContext, "toadletContext");
        this.handleRequest(new FreenetRequest(uri, Method.GET, httpRequest, toadletContext));
    }

    public final void handleMethodPOST(@Nullable URI uri, @Nullable HTTPRequest httpRequest, @Nullable ToadletContext toadletContext) {
        URI uRI = uri;
        if (uRI == null) {
            Intrinsics.throwNpe();
        }
        HTTPRequest hTTPRequest = httpRequest;
        if (hTTPRequest == null) {
            Intrinsics.throwNpe();
        }
        ToadletContext toadletContext2 = toadletContext;
        if (toadletContext2 == null) {
            Intrinsics.throwNpe();
        }
        this.handleRequest(new FreenetRequest(uRI, Method.POST, hTTPRequest, toadletContext2));
    }

    private final void handleRequest(FreenetRequest pageRequest) {
        RandomAccessBucket randomAccessBucket = pageRequest.getToadletContext().getBucketFactory().makeBucket(-1L);
        Intrinsics.checkExpressionValueIsNotNull(randomAccessBucket, "pageRequest.toadletConte\u2026ketFactory.makeBucket(-1)");
        BucketsKt.use((Bucket)randomAccessBucket, (Function1)new Function1<Bucket, Unit>(this, pageRequest){
            final /* synthetic */ PageToadlet this$0;
            final /* synthetic */ FreenetRequest $pageRequest;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public final void invoke(@NotNull Bucket pageBucket) {
                Intrinsics.checkParameterIsNotNull(pageBucket, "pageBucket");
                Closeable closeable = pageBucket.getOutputStream();
                boolean bl = false;
                Throwable throwable = null;
                try {
                    void $this$fold$iv;
                    Response pageResponse;
                    OutputStream pageBucketOutputStream = (OutputStream)closeable;
                    boolean bl2 = false;
                    Response response = pageResponse = PageToadlet.access$getPage$p(this.this$0).handleRequest((Request)this.$pageRequest, new Response(pageBucketOutputStream));
                    Intrinsics.checkExpressionValueIsNotNull(response, "pageResponse");
                    Iterable<Header> iterable = response.getHeaders();
                    Intrinsics.checkExpressionValueIsNotNull(iterable, "pageResponse.headers");
                    Iterable<Header> iterable2 = iterable;
                    MultiValueTable initial$iv = new MultiValueTable();
                    boolean $i$f$fold = false;
                    MultiValueTable accumulator$iv = initial$iv;
                    for (T element$iv : $this$fold$iv) {
                        void header;
                        Header header2 = (Header)element$iv;
                        MultiValueTable headers = accumulator$iv;
                        boolean bl3 = false;
                        MultiValueTable multiValueTable = headers;
                        boolean bl4 = false;
                        boolean bl5 = false;
                        MultiValueTable $this$apply = multiValueTable;
                        boolean bl6 = false;
                        void v2 = header;
                        Intrinsics.checkExpressionValueIsNotNull(v2, "header");
                        Iterable $this$forEach$iv = (Iterable)v2;
                        boolean $i$f$forEach = false;
                        for (T element$iv2 : $this$forEach$iv) {
                            String it = (String)element$iv2;
                            boolean bl7 = false;
                            $this$apply.put((Object)header.getName(), (Object)it);
                        }
                        accumulator$iv = multiValueTable;
                    }
                    MultiValueTable headers = accumulator$iv;
                    boolean bl8 = false;
                    boolean bl9 = false;
                    Response $this$with = pageResponse;
                    boolean bl10 = false;
                    PageToadlet.access$writeReply(this.this$0, this.$pageRequest.getToadletContext(), $this$with.getStatusCode(), $this$with.getContentType(), $this$with.getStatusText(), headers, pageBucket);
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally(closeable, throwable);
                }
            }
            {
                this.this$0 = pageToadlet;
                this.$pageRequest = freenetRequest;
                super(1);
            }
        });
    }

    public boolean isEnabled(@NotNull ToadletContext toadletContext) {
        Intrinsics.checkParameterIsNotNull(toadletContext, "toadletContext");
        return this.page instanceof LinkEnabledCallback ? ((LinkEnabledCallback)this.page).isEnabled(toadletContext) : true;
    }

    public boolean isLinkExcepted(@NotNull URI link) {
        Intrinsics.checkParameterIsNotNull(link, "link");
        return this.page instanceof FreenetPage && ((FreenetPage)this.page).isLinkExcepted(link);
    }

    @NotNull
    public String toString() {
        return ((Object)((Object)this)).getClass().getName() + "[path=" + this.path() + ",page=" + this.page + ']';
    }

    @Nullable
    public final String getMenuName() {
        return this.menuName;
    }

    public PageToadlet(@NotNull HighLevelSimpleClient highLevelSimpleClient, @Nullable String menuName, @NotNull Page<FreenetRequest> page, @NotNull String pathPrefix) {
        Intrinsics.checkParameterIsNotNull(highLevelSimpleClient, "highLevelSimpleClient");
        Intrinsics.checkParameterIsNotNull(page, "page");
        Intrinsics.checkParameterIsNotNull(pathPrefix, "pathPrefix");
        super(highLevelSimpleClient);
        this.menuName = menuName;
        this.page = page;
        this.pathPrefix = pathPrefix;
    }

    public static final /* synthetic */ Page access$getPage$p(PageToadlet $this) {
        return $this.page;
    }

    public static final /* synthetic */ void access$writeReply(PageToadlet $this, ToadletContext p0, int p1, String p2, String p3, MultiValueTable p4, Bucket p5) {
        $this.writeReply(p0, p1, p2, p3, p4, p5);
    }
}

