/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.sone.web.notification;

import com.google.common.eventbus.Subscribe;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.pterodactylus.sone.core.event.UpdateFoundEvent;
import net.pterodactylus.util.notify.NotificationManager;
import net.pterodactylus.util.notify.TemplateNotification;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0019\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lnet/pterodactylus/sone/web/notification/NewVersionHandler;", "", "notificationManager", "Lnet/pterodactylus/util/notify/NotificationManager;", "notification", "Lnet/pterodactylus/util/notify/TemplateNotification;", "(Lnet/pterodactylus/util/notify/NotificationManager;Lnet/pterodactylus/util/notify/TemplateNotification;)V", "newVersionFound", "", "updateFoundEvent", "Lnet/pterodactylus/sone/core/event/UpdateFoundEvent;", "Sone"})
public final class NewVersionHandler {
    private final NotificationManager notificationManager;
    private final TemplateNotification notification;

    @Subscribe
    public final void newVersionFound(@NotNull UpdateFoundEvent updateFoundEvent) {
        Intrinsics.checkParameterIsNotNull(updateFoundEvent, "updateFoundEvent");
        this.notification.set("latestVersion", updateFoundEvent.getVersion());
        this.notification.set("releaseTime", updateFoundEvent.getReleaseTime());
        this.notification.set("latestEdition", updateFoundEvent.getLatestEdition());
        this.notification.set("disruptive", updateFoundEvent.isDisruptive());
        this.notificationManager.addNotification(this.notification);
    }

    @Inject
    public NewVersionHandler(@NotNull NotificationManager notificationManager, @Named(value="newVersion") @NotNull TemplateNotification notification) {
        Intrinsics.checkParameterIsNotNull(notificationManager, "notificationManager");
        Intrinsics.checkParameterIsNotNull(notification, "notification");
        this.notificationManager = notificationManager;
        this.notification = notification;
    }
}

