/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.sone.web.notification;

import com.google.common.eventbus.Subscribe;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.pterodactylus.sone.core.event.MarkSoneKnownEvent;
import net.pterodactylus.sone.core.event.NewSoneFoundEvent;
import net.pterodactylus.sone.core.event.SoneRemovedEvent;
import net.pterodactylus.sone.data.Sone;
import net.pterodactylus.sone.notify.ListNotification;
import net.pterodactylus.sone.notify.NotificationsKt;
import net.pterodactylus.util.notify.NotificationManager;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0001\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0010\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lnet/pterodactylus/sone/web/notification/NewSoneHandler;", "", "notificationManager", "Lnet/pterodactylus/util/notify/NotificationManager;", "notification", "Lnet/pterodactylus/sone/notify/ListNotification;", "Lnet/pterodactylus/sone/data/Sone;", "(Lnet/pterodactylus/util/notify/NotificationManager;Lnet/pterodactylus/sone/notify/ListNotification;)V", "markedSoneKnown", "", "markSoneKnownEvent", "Lnet/pterodactylus/sone/core/event/MarkSoneKnownEvent;", "newSoneFound", "newSoneFoundEvent", "Lnet/pterodactylus/sone/core/event/NewSoneFoundEvent;", "soneRemoved", "soneRemovedEvent", "Lnet/pterodactylus/sone/core/event/SoneRemovedEvent;", "Sone"})
public final class NewSoneHandler {
    private final NotificationManager notificationManager;
    private final ListNotification<Sone> notification;

    @Subscribe
    public final void newSoneFound(@NotNull NewSoneFoundEvent newSoneFoundEvent) {
        Intrinsics.checkParameterIsNotNull(newSoneFoundEvent, "newSoneFoundEvent");
        if (!NotificationsKt.hasFirstStartNotification(this.notificationManager)) {
            this.notification.add(newSoneFoundEvent.getSone());
            this.notificationManager.addNotification(this.notification);
        }
    }

    @Subscribe
    public final void markedSoneKnown(@NotNull MarkSoneKnownEvent markSoneKnownEvent) {
        Intrinsics.checkParameterIsNotNull(markSoneKnownEvent, "markSoneKnownEvent");
        this.notification.remove(markSoneKnownEvent.getSone());
    }

    @Subscribe
    public final void soneRemoved(@NotNull SoneRemovedEvent soneRemovedEvent) {
        Intrinsics.checkParameterIsNotNull(soneRemovedEvent, "soneRemovedEvent");
        this.notification.remove(soneRemovedEvent.getSone());
    }

    @Inject
    public NewSoneHandler(@NotNull NotificationManager notificationManager, @Named(value="newSone") @NotNull ListNotification<Sone> notification) {
        Intrinsics.checkParameterIsNotNull(notificationManager, "notificationManager");
        Intrinsics.checkParameterIsNotNull(notification, "notification");
        this.notificationManager = notificationManager;
        this.notification = notification;
    }
}

