/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.sone.web.notification;

import com.google.common.eventbus.Subscribe;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.pterodactylus.sone.core.event.ImageInsertAbortedEvent;
import net.pterodactylus.sone.core.event.ImageInsertFailedEvent;
import net.pterodactylus.sone.core.event.ImageInsertFinishedEvent;
import net.pterodactylus.sone.core.event.ImageInsertStartedEvent;
import net.pterodactylus.sone.data.Image;
import net.pterodactylus.sone.notify.ListNotification;
import net.pterodactylus.util.notify.NotificationManager;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B?\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0001\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u000e\b\u0001\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u000e\b\u0001\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u0010\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0007J\u0010\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0007R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lnet/pterodactylus/sone/web/notification/ImageInsertHandler;", "", "notificationManager", "Lnet/pterodactylus/util/notify/NotificationManager;", "imageInsertingNotification", "Lnet/pterodactylus/sone/notify/ListNotification;", "Lnet/pterodactylus/sone/data/Image;", "imageFailedNotification", "imageInsertedNotification", "(Lnet/pterodactylus/util/notify/NotificationManager;Lnet/pterodactylus/sone/notify/ListNotification;Lnet/pterodactylus/sone/notify/ListNotification;Lnet/pterodactylus/sone/notify/ListNotification;)V", "imageInsertAborted", "", "imageInsertAbortedEvent", "Lnet/pterodactylus/sone/core/event/ImageInsertAbortedEvent;", "imageInsertFailed", "imageInsertFailedEvent", "Lnet/pterodactylus/sone/core/event/ImageInsertFailedEvent;", "imageInsertFinished", "imageInsertFinishedEvent", "Lnet/pterodactylus/sone/core/event/ImageInsertFinishedEvent;", "imageInsertStarted", "imageInsertStartedEvent", "Lnet/pterodactylus/sone/core/event/ImageInsertStartedEvent;", "Sone"})
public final class ImageInsertHandler {
    private final NotificationManager notificationManager;
    private final ListNotification<Image> imageInsertingNotification;
    private final ListNotification<Image> imageFailedNotification;
    private final ListNotification<Image> imageInsertedNotification;

    @Subscribe
    public final void imageInsertStarted(@NotNull ImageInsertStartedEvent imageInsertStartedEvent) {
        Intrinsics.checkParameterIsNotNull(imageInsertStartedEvent, "imageInsertStartedEvent");
        this.imageInsertingNotification.add(imageInsertStartedEvent.getImage());
        this.notificationManager.addNotification(this.imageInsertingNotification);
    }

    @Subscribe
    public final void imageInsertAborted(@NotNull ImageInsertAbortedEvent imageInsertAbortedEvent) {
        Intrinsics.checkParameterIsNotNull(imageInsertAbortedEvent, "imageInsertAbortedEvent");
        this.imageInsertingNotification.remove(imageInsertAbortedEvent.getImage());
    }

    @Subscribe
    public final void imageInsertFailed(@NotNull ImageInsertFailedEvent imageInsertFailedEvent) {
        Intrinsics.checkParameterIsNotNull(imageInsertFailedEvent, "imageInsertFailedEvent");
        this.imageInsertingNotification.remove(imageInsertFailedEvent.getImage());
        this.imageFailedNotification.add(imageInsertFailedEvent.getImage());
        this.notificationManager.addNotification(this.imageFailedNotification);
    }

    @Subscribe
    public final void imageInsertFinished(@NotNull ImageInsertFinishedEvent imageInsertFinishedEvent) {
        Intrinsics.checkParameterIsNotNull(imageInsertFinishedEvent, "imageInsertFinishedEvent");
        this.imageInsertingNotification.remove(imageInsertFinishedEvent.getImage());
        this.imageInsertedNotification.add(imageInsertFinishedEvent.getImage());
        this.notificationManager.addNotification(this.imageInsertedNotification);
    }

    @Inject
    public ImageInsertHandler(@NotNull NotificationManager notificationManager, @Named(value="imageInserting") @NotNull ListNotification<Image> imageInsertingNotification, @Named(value="imageFailed") @NotNull ListNotification<Image> imageFailedNotification, @Named(value="imageInserted") @NotNull ListNotification<Image> imageInsertedNotification) {
        Intrinsics.checkParameterIsNotNull(notificationManager, "notificationManager");
        Intrinsics.checkParameterIsNotNull(imageInsertingNotification, "imageInsertingNotification");
        Intrinsics.checkParameterIsNotNull(imageFailedNotification, "imageFailedNotification");
        Intrinsics.checkParameterIsNotNull(imageInsertedNotification, "imageInsertedNotification");
        this.notificationManager = notificationManager;
        this.imageInsertingNotification = imageInsertingNotification;
        this.imageFailedNotification = imageFailedNotification;
        this.imageInsertedNotification = imageInsertedNotification;
    }
}

