/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.sone.web.ajax;

import com.fasterxml.jackson.databind.ObjectMapper;
import freenet.clients.http.ToadletContext;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.OutputStream;
import java.io.PrintStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import net.pterodactylus.sone.core.Core;
import net.pterodactylus.sone.data.Sone;
import net.pterodactylus.sone.utils.Parameters;
import net.pterodactylus.sone.utils.RequestsKt;
import net.pterodactylus.sone.web.SessionProvider;
import net.pterodactylus.sone.web.WebInterface;
import net.pterodactylus.sone.web.ajax.JsonErrorReturnObject;
import net.pterodactylus.sone.web.ajax.JsonReturnObject;
import net.pterodactylus.sone.web.page.AnnotationsKt;
import net.pterodactylus.sone.web.page.FreenetRequest;
import net.pterodactylus.util.web.Page;
import net.pterodactylus.util.web.Response;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0003\n\u0000\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0004J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0002H&J\b\u0010\u001d\u001a\u00020\u001bH\u0004J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020!H\u0004J\n\u0010\"\u001a\u0004\u0018\u00010\u0019H\u0016J\u0018\u0010#\u001a\u00020$2\u0006\u0010\u001c\u001a\u00020\u00022\u0006\u0010%\u001a\u00020$H\u0016J\b\u0010&\u001a\u00020\u000bH\u0016J\f\u0010'\u001a\u00020\u0019*\u00020\u001bH\u0002J\f\u0010(\u001a\u00020\u0019*\u00020)H\u0002R\u0014\u0010\u0006\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u000bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\rR\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\u00020\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006*"}, d2={"Lnet/pterodactylus/sone/web/ajax/JsonPage;", "Lnet/pterodactylus/util/web/Page;", "Lnet/pterodactylus/sone/web/page/FreenetRequest;", "webInterface", "Lnet/pterodactylus/sone/web/WebInterface;", "(Lnet/pterodactylus/sone/web/WebInterface;)V", "core", "Lnet/pterodactylus/sone/core/Core;", "getCore", "()Lnet/pterodactylus/sone/core/Core;", "needsFormPassword", "", "getNeedsFormPassword", "()Z", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "requiresLogin", "getRequiresLogin", "sessionProvider", "Lnet/pterodactylus/sone/web/SessionProvider;", "getWebInterface", "()Lnet/pterodactylus/sone/web/WebInterface;", "createErrorJsonObject", "Lnet/pterodactylus/sone/web/ajax/JsonErrorReturnObject;", "error", "", "createJsonObject", "Lnet/pterodactylus/sone/web/ajax/JsonReturnObject;", "request", "createSuccessJsonObject", "getCurrentSone", "Lnet/pterodactylus/sone/data/Sone;", "toadletContext", "Lfreenet/clients/http/ToadletContext;", "getPath", "handleRequest", "Lnet/pterodactylus/util/web/Response;", "response", "isPrefixPage", "asJsonString", "dumpStackTrace", "", "Sone"})
public abstract class JsonPage
implements Page<FreenetRequest> {
    private final ObjectMapper objectMapper;
    private final SessionProvider sessionProvider;
    @NotNull
    private final Core core;
    private final boolean needsFormPassword = true;
    private final boolean requiresLogin = true;
    @NotNull
    private final WebInterface webInterface;

    @NotNull
    protected final Core getCore() {
        return this.core;
    }

    @Override
    @Nullable
    public String getPath() {
        return AnnotationsKt.getToadletPath(this);
    }

    @Override
    public boolean isPrefixPage() {
        return false;
    }

    public boolean getNeedsFormPassword() {
        return this.needsFormPassword;
    }

    public boolean getRequiresLogin() {
        return this.requiresLogin;
    }

    @NotNull
    protected final JsonReturnObject createSuccessJsonObject() {
        return new JsonReturnObject(true);
    }

    @NotNull
    protected final JsonErrorReturnObject createErrorJsonObject(@NotNull String error) {
        Intrinsics.checkParameterIsNotNull(error, "error");
        return new JsonErrorReturnObject(error);
    }

    @Nullable
    protected final Sone getCurrentSone(@NotNull ToadletContext toadletContext) {
        Intrinsics.checkParameterIsNotNull(toadletContext, "toadletContext");
        return this.sessionProvider.getCurrentSone(toadletContext);
    }

    @Override
    @NotNull
    public Response handleRequest(@NotNull FreenetRequest request, @NotNull Response response) {
        Response response2;
        Intrinsics.checkParameterIsNotNull(request, "request");
        Intrinsics.checkParameterIsNotNull(response, "response");
        if (this.core.getPreferences().getRequireFullAccess() && !request.getToadletContext().isAllowedFullAccess()) {
            Response response3 = response.setStatusCode(403).setStatusText("Forbidden").setContentType("application/json").write(this.asJsonString(this.createErrorJsonObject("auth-required")));
            Intrinsics.checkExpressionValueIsNotNull(response3, "response.setStatusCode(4\u2026equired\").asJsonString())");
            return response3;
        }
        if (this.getNeedsFormPassword() && Intrinsics.areEqual(Parameters.get$default(RequestsKt.getParameters(request), "formPassword", 0, 2, null), this.webInterface.getFormPassword()) ^ true) {
            Response response4 = response.setStatusCode(403).setStatusText("Forbidden").setContentType("application/json").write(this.asJsonString(this.createErrorJsonObject("auth-required")));
            Intrinsics.checkExpressionValueIsNotNull(response4, "response.setStatusCode(4\u2026equired\").asJsonString())");
            return response4;
        }
        if (this.getRequiresLogin() && this.sessionProvider.getCurrentSone(request.getToadletContext()) == null) {
            Response response5 = response.setStatusCode(403).setStatusText("Forbidden").setContentType("application/json").write(this.asJsonString(this.createErrorJsonObject("auth-required")));
            Intrinsics.checkExpressionValueIsNotNull(response5, "response.setStatusCode(4\u2026equired\").asJsonString())");
            return response5;
        }
        try {
            Response response6 = response.setStatusCode(200).setStatusText("OK").setContentType("application/json").write(this.asJsonString(this.createJsonObject(request)));
            Intrinsics.checkExpressionValueIsNotNull(response6, "response.setStatusCode(2\u2026(request).asJsonString())");
            response2 = response6;
        }
        catch (Exception e) {
            Response response7 = response.setStatusCode(500).setStatusText(e.getMessage()).setContentType("text/plain").write(this.dumpStackTrace(e));
            Intrinsics.checkExpressionValueIsNotNull(response7, "response.setStatusCode(5\u2026write(e.dumpStackTrace())");
            response2 = response7;
        }
        return response2;
    }

    @NotNull
    public abstract JsonReturnObject createJsonObject(@NotNull FreenetRequest var1);

    private final String asJsonString(@NotNull JsonReturnObject $this$asJsonString) {
        String string = this.objectMapper.writeValueAsString($this$asJsonString);
        Intrinsics.checkExpressionValueIsNotNull(string, "objectMapper.writeValueAsString(this)");
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String dumpStackTrace(@NotNull Throwable $this$dumpStackTrace) {
        String string;
        Closeable closeable = new ByteArrayOutputStream();
        boolean bl = false;
        Throwable throwable = null;
        try {
            ByteArrayOutputStream it = (ByteArrayOutputStream)closeable;
            boolean bl2 = false;
            Closeable closeable2 = new PrintStream((OutputStream)it, true, "UTF-8");
            boolean bl3 = false;
            Throwable throwable2 = null;
            try {
                PrintStream it2 = (PrintStream)closeable2;
                boolean bl4 = false;
                $this$dumpStackTrace.printStackTrace(it2);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally(closeable2, throwable2);
            }
            String string2 = it.toString("UTF-8");
            Intrinsics.checkExpressionValueIsNotNull(string2, "it.toString(\"UTF-8\")");
            String string3 = string2;
            string = string3;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
        Intrinsics.checkExpressionValueIsNotNull(string, "ByteArrayOutputStream().\u2026\t\tit.toString(\"UTF-8\")\n\t}");
        return string;
    }

    @NotNull
    protected final WebInterface getWebInterface() {
        return this.webInterface;
    }

    public JsonPage(@NotNull WebInterface webInterface) {
        Intrinsics.checkParameterIsNotNull(webInterface, "webInterface");
        this.webInterface = webInterface;
        this.objectMapper = new ObjectMapper();
        this.sessionProvider = this.webInterface;
        Core core = this.webInterface.getCore();
        Intrinsics.checkExpressionValueIsNotNull(core, "webInterface.core");
        this.core = core;
        this.needsFormPassword = true;
        this.requiresLogin = true;
    }
}

