/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.sone.web;

import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import freenet.support.api.HTTPRequest;
import java.util.Collection;
import javax.inject.Named;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.pterodactylus.sone.core.Core;
import net.pterodactylus.sone.core.ElementLoader;
import net.pterodactylus.sone.data.Album;
import net.pterodactylus.sone.data.Image;
import net.pterodactylus.sone.data.Post;
import net.pterodactylus.sone.data.Profile;
import net.pterodactylus.sone.data.Reply;
import net.pterodactylus.sone.data.Sone;
import net.pterodactylus.sone.database.SoneProvider;
import net.pterodactylus.sone.freenet.L10nFilter;
import net.pterodactylus.sone.freenet.Translation;
import net.pterodactylus.sone.freenet.wot.Identity;
import net.pterodactylus.sone.freenet.wot.Trust;
import net.pterodactylus.sone.main.Loaders;
import net.pterodactylus.sone.main.ReparseFilter;
import net.pterodactylus.sone.template.AlbumAccessor;
import net.pterodactylus.sone.template.CollectionAccessor;
import net.pterodactylus.sone.template.CssClassNameFilter;
import net.pterodactylus.sone.template.DurationFormatFilter;
import net.pterodactylus.sone.template.HistogramRenderer;
import net.pterodactylus.sone.template.HttpRequestAccessor;
import net.pterodactylus.sone.template.IdentityAccessor;
import net.pterodactylus.sone.template.ImageAccessor;
import net.pterodactylus.sone.template.ImageLinkFilter;
import net.pterodactylus.sone.template.JavascriptFilter;
import net.pterodactylus.sone.template.LinkedElementRenderFilter;
import net.pterodactylus.sone.template.LinkedElementsFilter;
import net.pterodactylus.sone.template.ParserFilter;
import net.pterodactylus.sone.template.PostAccessor;
import net.pterodactylus.sone.template.ProfileAccessor;
import net.pterodactylus.sone.template.RenderFilter;
import net.pterodactylus.sone.template.ReplyAccessor;
import net.pterodactylus.sone.template.ReplyGroupFilter;
import net.pterodactylus.sone.template.RequestChangeFilter;
import net.pterodactylus.sone.template.ShortenFilter;
import net.pterodactylus.sone.template.SoneAccessor;
import net.pterodactylus.sone.template.SubstringFilter;
import net.pterodactylus.sone.template.TrustAccessor;
import net.pterodactylus.sone.template.UniqueElementFilter;
import net.pterodactylus.sone.template.UnknownDateFilter;
import net.pterodactylus.sone.text.SoneTextParser;
import net.pterodactylus.sone.text.TimeTextConverter;
import net.pterodactylus.util.notify.NotificationManager;
import net.pterodactylus.util.template.CollectionSortFilter;
import net.pterodactylus.util.template.ContainsFilter;
import net.pterodactylus.util.template.DateFilter;
import net.pterodactylus.util.template.FormatFilter;
import net.pterodactylus.util.template.HtmlFilter;
import net.pterodactylus.util.template.MatchFilter;
import net.pterodactylus.util.template.ModFilter;
import net.pterodactylus.util.template.PaginationFilter;
import net.pterodactylus.util.template.ReflectionAccessor;
import net.pterodactylus.util.template.ReplaceFilter;
import net.pterodactylus.util.template.StoreFilter;
import net.pterodactylus.util.template.TemplateContextFactory;
import net.pterodactylus.util.template.TemplateProvider;
import net.pterodactylus.util.template.XmlFilter;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\b\u0010\u0011\u001a\u00020\u0012H\u0007J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0016H\u0007J\b\u0010\u0017\u001a\u00020\u0018H\u0007J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J \u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010!\u001a\u00020\"H\u0007J\u0010\u0010#\u001a\u00020$2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0018\u0010%\u001a\u00020&2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010'\u001a\u00020(H\u0007Jh\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020&2\u0006\u0010,\u001a\u00020\u001a2\u0006\u0010-\u001a\u00020$2\u0006\u0010.\u001a\u00020\u00042\u0006\u0010/\u001a\u00020\u001c2\u0006\u00100\u001a\u00020\n2\u0006\u00101\u001a\u00020\u00142\u0006\u00102\u001a\u00020\u001e2\u0006\u00103\u001a\u00020\u000e2\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u00020\b2\u0006\u00107\u001a\u000208H\u0007J\u0010\u00109\u001a\u0002052\u0006\u0010\u000b\u001a\u00020\fH\u0007\u00a8\u0006:"}, d2={"Lnet/pterodactylus/sone/web/WebInterfaceModule;", "Lcom/google/inject/AbstractModule;", "()V", "getIdentityAccessor", "Lnet/pterodactylus/sone/template/IdentityAccessor;", "core", "Lnet/pterodactylus/sone/core/Core;", "getImageLinkFilter", "Lnet/pterodactylus/sone/template/ImageLinkFilter;", "getL10nFilter", "Lnet/pterodactylus/sone/freenet/L10nFilter;", "translation", "Lnet/pterodactylus/sone/freenet/Translation;", "getLinkedElementsFilter", "Lnet/pterodactylus/sone/template/LinkedElementsFilter;", "elementLoader", "Lnet/pterodactylus/sone/core/ElementLoader;", "getNotificationManager", "Lnet/pterodactylus/util/notify/NotificationManager;", "getParserFilter", "Lnet/pterodactylus/sone/template/ParserFilter;", "soneTextParser", "Lnet/pterodactylus/sone/text/SoneTextParser;", "getPathPrefix", "", "getPostAccessor", "Lnet/pterodactylus/sone/template/PostAccessor;", "getProfileAccessor", "Lnet/pterodactylus/sone/template/ProfileAccessor;", "getRenderFilter", "Lnet/pterodactylus/sone/template/RenderFilter;", "soneProvider", "Lnet/pterodactylus/sone/database/SoneProvider;", "htmlFilter", "Lnet/pterodactylus/util/template/HtmlFilter;", "getReplyAccessor", "Lnet/pterodactylus/sone/template/ReplyAccessor;", "getSoneAccessor", "Lnet/pterodactylus/sone/template/SoneAccessor;", "timeTextConverter", "Lnet/pterodactylus/sone/text/TimeTextConverter;", "getTemplateContextFactory", "Lnet/pterodactylus/util/template/TemplateContextFactory;", "soneAccessor", "postAccessor", "replyAccessor", "identityAccessor", "profileAccessor", "l10nFilter", "parserFilter", "renderFilter", "linkedElementsFilter", "unknownDateFilter", "Lnet/pterodactylus/sone/template/UnknownDateFilter;", "imageLinkFilter", "loaders", "Lnet/pterodactylus/sone/main/Loaders;", "getUnknownDateFilter", "Sone"})
public final class WebInterfaceModule
extends AbstractModule {
    @Provides
    @Singleton
    @NotNull
    public final TemplateContextFactory getTemplateContextFactory(@NotNull SoneAccessor soneAccessor, @NotNull PostAccessor postAccessor, @NotNull ReplyAccessor replyAccessor, @NotNull IdentityAccessor identityAccessor, @NotNull ProfileAccessor profileAccessor, @NotNull L10nFilter l10nFilter, @NotNull ParserFilter parserFilter, @NotNull RenderFilter renderFilter, @NotNull LinkedElementsFilter linkedElementsFilter, @NotNull UnknownDateFilter unknownDateFilter, @NotNull ImageLinkFilter imageLinkFilter, @NotNull Loaders loaders) {
        Intrinsics.checkParameterIsNotNull(soneAccessor, "soneAccessor");
        Intrinsics.checkParameterIsNotNull(postAccessor, "postAccessor");
        Intrinsics.checkParameterIsNotNull(replyAccessor, "replyAccessor");
        Intrinsics.checkParameterIsNotNull(identityAccessor, "identityAccessor");
        Intrinsics.checkParameterIsNotNull(profileAccessor, "profileAccessor");
        Intrinsics.checkParameterIsNotNull(l10nFilter, "l10nFilter");
        Intrinsics.checkParameterIsNotNull(parserFilter, "parserFilter");
        Intrinsics.checkParameterIsNotNull(renderFilter, "renderFilter");
        Intrinsics.checkParameterIsNotNull(linkedElementsFilter, "linkedElementsFilter");
        Intrinsics.checkParameterIsNotNull(unknownDateFilter, "unknownDateFilter");
        Intrinsics.checkParameterIsNotNull(imageLinkFilter, "imageLinkFilter");
        Intrinsics.checkParameterIsNotNull(loaders, "loaders");
        TemplateContextFactory templateContextFactory = new TemplateContextFactory();
        boolean bl = false;
        boolean bl2 = false;
        TemplateContextFactory $this$apply = templateContextFactory;
        boolean bl3 = false;
        $this$apply.addAccessor(Object.class, new ReflectionAccessor());
        $this$apply.addAccessor(Collection.class, new CollectionAccessor());
        $this$apply.addAccessor(Sone.class, soneAccessor);
        $this$apply.addAccessor(Post.class, postAccessor);
        $this$apply.addAccessor(Reply.class, replyAccessor);
        $this$apply.addAccessor(Album.class, new AlbumAccessor());
        $this$apply.addAccessor(Image.class, new ImageAccessor());
        $this$apply.addAccessor(Identity.class, identityAccessor);
        $this$apply.addAccessor(Trust.class, new TrustAccessor());
        $this$apply.addAccessor(HTTPRequest.class, new HttpRequestAccessor());
        $this$apply.addAccessor(Profile.class, profileAccessor);
        $this$apply.addFilter("date", new DateFilter());
        $this$apply.addFilter("html", new HtmlFilter());
        $this$apply.addFilter("replace", new ReplaceFilter());
        $this$apply.addFilter("store", new StoreFilter());
        $this$apply.addFilter("l10n", l10nFilter);
        $this$apply.addFilter("substring", new SubstringFilter());
        $this$apply.addFilter("xml", new XmlFilter());
        $this$apply.addFilter("change", new RequestChangeFilter());
        $this$apply.addFilter("match", new MatchFilter());
        $this$apply.addFilter("css", new CssClassNameFilter());
        $this$apply.addFilter("js", new JavascriptFilter());
        $this$apply.addFilter("parse", parserFilter);
        $this$apply.addFilter("shorten", new ShortenFilter());
        $this$apply.addFilter("render", renderFilter);
        $this$apply.addFilter("linked-elements", linkedElementsFilter);
        $this$apply.addFilter("render-linked-element", new LinkedElementRenderFilter());
        $this$apply.addFilter("reparse", new ReparseFilter());
        $this$apply.addFilter("unknown", unknownDateFilter);
        $this$apply.addFilter("format", new FormatFilter());
        $this$apply.addFilter("duration", new DurationFormatFilter());
        $this$apply.addFilter("sort", new CollectionSortFilter());
        $this$apply.addFilter("image-link", imageLinkFilter);
        $this$apply.addFilter("replyGroup", new ReplyGroupFilter());
        $this$apply.addFilter("in", new ContainsFilter());
        $this$apply.addFilter("unique", new UniqueElementFilter());
        $this$apply.addFilter("mod", new ModFilter());
        $this$apply.addFilter("paginate", new PaginationFilter());
        $this$apply.addFilter("render-histogram", new HistogramRenderer());
        $this$apply.addProvider(TemplateProvider.TEMPLATE_CONTEXT_PROVIDER);
        $this$apply.addProvider(loaders.getTemplateProvider());
        return templateContextFactory;
    }

    @Provides
    @NotNull
    public final SoneAccessor getSoneAccessor(@NotNull Core core, @NotNull TimeTextConverter timeTextConverter) {
        Intrinsics.checkParameterIsNotNull(core, "core");
        Intrinsics.checkParameterIsNotNull(timeTextConverter, "timeTextConverter");
        return new SoneAccessor(core, timeTextConverter);
    }

    @Provides
    @NotNull
    public final PostAccessor getPostAccessor(@NotNull Core core) {
        Intrinsics.checkParameterIsNotNull(core, "core");
        return new PostAccessor(core);
    }

    @Provides
    @NotNull
    public final ReplyAccessor getReplyAccessor(@NotNull Core core) {
        Intrinsics.checkParameterIsNotNull(core, "core");
        return new ReplyAccessor(core);
    }

    @Provides
    @NotNull
    public final IdentityAccessor getIdentityAccessor(@NotNull Core core) {
        Intrinsics.checkParameterIsNotNull(core, "core");
        return new IdentityAccessor(core);
    }

    @Provides
    @NotNull
    public final ProfileAccessor getProfileAccessor(@NotNull Core core) {
        Intrinsics.checkParameterIsNotNull(core, "core");
        return new ProfileAccessor(core);
    }

    @Provides
    @NotNull
    public final L10nFilter getL10nFilter(@NotNull Translation translation) {
        Intrinsics.checkParameterIsNotNull(translation, "translation");
        return new L10nFilter(translation);
    }

    @Provides
    @NotNull
    public final ParserFilter getParserFilter(@NotNull Core core, @NotNull SoneTextParser soneTextParser) {
        Intrinsics.checkParameterIsNotNull(core, "core");
        Intrinsics.checkParameterIsNotNull(soneTextParser, "soneTextParser");
        return new ParserFilter(core, soneTextParser);
    }

    @Provides
    @NotNull
    public final RenderFilter getRenderFilter(@NotNull SoneProvider soneProvider, @NotNull SoneTextParser soneTextParser, @NotNull HtmlFilter htmlFilter) {
        Intrinsics.checkParameterIsNotNull(soneProvider, "soneProvider");
        Intrinsics.checkParameterIsNotNull(soneTextParser, "soneTextParser");
        Intrinsics.checkParameterIsNotNull(htmlFilter, "htmlFilter");
        return new RenderFilter(soneProvider, soneTextParser, htmlFilter);
    }

    @Provides
    @NotNull
    public final LinkedElementsFilter getLinkedElementsFilter(@NotNull ElementLoader elementLoader) {
        Intrinsics.checkParameterIsNotNull(elementLoader, "elementLoader");
        return new LinkedElementsFilter(elementLoader);
    }

    @Provides
    @NotNull
    public final UnknownDateFilter getUnknownDateFilter(@NotNull Translation translation) {
        Intrinsics.checkParameterIsNotNull(translation, "translation");
        return new UnknownDateFilter(translation, "View.Sone.Text.UnknownDate");
    }

    @Provides
    @NotNull
    public final ImageLinkFilter getImageLinkFilter(@NotNull Core core) {
        Intrinsics.checkParameterIsNotNull(core, "core");
        return new ImageLinkFilter(core);
    }

    @Provides
    @Named(value="toadletPathPrefix")
    @NotNull
    public final String getPathPrefix() {
        return "/Sone/";
    }

    @Provides
    @Singleton
    @NotNull
    public final NotificationManager getNotificationManager() {
        return new NotificationManager();
    }
}

