/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.sone.web;

import com.codahale.metrics.MetricRegistry;
import com.google.common.base.Optional;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableSet;
import com.google.common.eventbus.Subscribe;
import com.google.inject.Inject;
import freenet.clients.http.ToadletContext;
import java.util.Collection;
import java.util.TimeZone;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Named;
import net.pterodactylus.sone.core.Core;
import net.pterodactylus.sone.core.ElementLoader;
import net.pterodactylus.sone.core.event.DebugActivatedEvent;
import net.pterodactylus.sone.data.Post;
import net.pterodactylus.sone.data.PostReply;
import net.pterodactylus.sone.data.Sone;
import net.pterodactylus.sone.freenet.L10nFilter;
import net.pterodactylus.sone.freenet.Translation;
import net.pterodactylus.sone.main.Loaders;
import net.pterodactylus.sone.main.PluginHomepage;
import net.pterodactylus.sone.main.PluginVersion;
import net.pterodactylus.sone.main.PluginYear;
import net.pterodactylus.sone.main.SonePlugin;
import net.pterodactylus.sone.notify.ListNotification;
import net.pterodactylus.sone.notify.ListNotificationFilter;
import net.pterodactylus.sone.notify.PostVisibilityFilter;
import net.pterodactylus.sone.notify.ReplyVisibilityFilter;
import net.pterodactylus.sone.template.LinkedElementRenderFilter;
import net.pterodactylus.sone.template.ParserFilter;
import net.pterodactylus.sone.template.RenderFilter;
import net.pterodactylus.sone.template.ShortenFilter;
import net.pterodactylus.sone.text.TimeTextConverter;
import net.pterodactylus.sone.web.PageToadletRegistry;
import net.pterodactylus.sone.web.SessionProvider;
import net.pterodactylus.sone.web.ajax.BookmarkAjaxPage;
import net.pterodactylus.sone.web.ajax.CreatePostAjaxPage;
import net.pterodactylus.sone.web.ajax.CreateReplyAjaxPage;
import net.pterodactylus.sone.web.ajax.DeletePostAjaxPage;
import net.pterodactylus.sone.web.ajax.DeleteProfileFieldAjaxPage;
import net.pterodactylus.sone.web.ajax.DeleteReplyAjaxPage;
import net.pterodactylus.sone.web.ajax.DismissNotificationAjaxPage;
import net.pterodactylus.sone.web.ajax.EditAlbumAjaxPage;
import net.pterodactylus.sone.web.ajax.EditImageAjaxPage;
import net.pterodactylus.sone.web.ajax.EditProfileFieldAjaxPage;
import net.pterodactylus.sone.web.ajax.FollowSoneAjaxPage;
import net.pterodactylus.sone.web.ajax.GetLikesAjaxPage;
import net.pterodactylus.sone.web.ajax.GetLinkedElementAjaxPage;
import net.pterodactylus.sone.web.ajax.GetNotificationsAjaxPage;
import net.pterodactylus.sone.web.ajax.GetPostAjaxPage;
import net.pterodactylus.sone.web.ajax.GetReplyAjaxPage;
import net.pterodactylus.sone.web.ajax.GetStatusAjaxPage;
import net.pterodactylus.sone.web.ajax.GetTimesAjaxPage;
import net.pterodactylus.sone.web.ajax.GetTranslationAjaxPage;
import net.pterodactylus.sone.web.ajax.LikeAjaxPage;
import net.pterodactylus.sone.web.ajax.LockSoneAjaxPage;
import net.pterodactylus.sone.web.ajax.MarkAsKnownAjaxPage;
import net.pterodactylus.sone.web.ajax.MoveProfileFieldAjaxPage;
import net.pterodactylus.sone.web.ajax.UnbookmarkAjaxPage;
import net.pterodactylus.sone.web.ajax.UnfollowSoneAjaxPage;
import net.pterodactylus.sone.web.ajax.UnlikeAjaxPage;
import net.pterodactylus.sone.web.ajax.UnlockSoneAjaxPage;
import net.pterodactylus.sone.web.page.FreenetRequest;
import net.pterodactylus.sone.web.page.TemplateRenderer;
import net.pterodactylus.sone.web.pages.AboutPage;
import net.pterodactylus.sone.web.pages.BookmarkPage;
import net.pterodactylus.sone.web.pages.BookmarksPage;
import net.pterodactylus.sone.web.pages.CreateAlbumPage;
import net.pterodactylus.sone.web.pages.CreatePostPage;
import net.pterodactylus.sone.web.pages.CreateReplyPage;
import net.pterodactylus.sone.web.pages.CreateSonePage;
import net.pterodactylus.sone.web.pages.DebugPage;
import net.pterodactylus.sone.web.pages.DeleteAlbumPage;
import net.pterodactylus.sone.web.pages.DeleteImagePage;
import net.pterodactylus.sone.web.pages.DeletePostPage;
import net.pterodactylus.sone.web.pages.DeleteProfileFieldPage;
import net.pterodactylus.sone.web.pages.DeleteReplyPage;
import net.pterodactylus.sone.web.pages.DeleteSonePage;
import net.pterodactylus.sone.web.pages.DismissNotificationPage;
import net.pterodactylus.sone.web.pages.EditAlbumPage;
import net.pterodactylus.sone.web.pages.EditImagePage;
import net.pterodactylus.sone.web.pages.EditProfileFieldPage;
import net.pterodactylus.sone.web.pages.EditProfilePage;
import net.pterodactylus.sone.web.pages.EmptyAlbumTitlePage;
import net.pterodactylus.sone.web.pages.EmptyImageTitlePage;
import net.pterodactylus.sone.web.pages.FollowSonePage;
import net.pterodactylus.sone.web.pages.GetImagePage;
import net.pterodactylus.sone.web.pages.ImageBrowserPage;
import net.pterodactylus.sone.web.pages.IndexPage;
import net.pterodactylus.sone.web.pages.InvalidPage;
import net.pterodactylus.sone.web.pages.KnownSonesPage;
import net.pterodactylus.sone.web.pages.LikePage;
import net.pterodactylus.sone.web.pages.LockSonePage;
import net.pterodactylus.sone.web.pages.LoginPage;
import net.pterodactylus.sone.web.pages.LogoutPage;
import net.pterodactylus.sone.web.pages.MarkAsKnownPage;
import net.pterodactylus.sone.web.pages.MetricsPage;
import net.pterodactylus.sone.web.pages.NewPage;
import net.pterodactylus.sone.web.pages.NoPermissionPage;
import net.pterodactylus.sone.web.pages.OptionsPage;
import net.pterodactylus.sone.web.pages.RescuePage;
import net.pterodactylus.sone.web.pages.SearchPage;
import net.pterodactylus.sone.web.pages.UnbookmarkPage;
import net.pterodactylus.sone.web.pages.UnfollowSonePage;
import net.pterodactylus.sone.web.pages.UnlikePage;
import net.pterodactylus.sone.web.pages.UnlockSonePage;
import net.pterodactylus.sone.web.pages.UploadImagePage;
import net.pterodactylus.sone.web.pages.ViewPostPage;
import net.pterodactylus.sone.web.pages.ViewSonePage;
import net.pterodactylus.util.notify.Notification;
import net.pterodactylus.util.notify.NotificationManager;
import net.pterodactylus.util.template.Template;
import net.pterodactylus.util.template.TemplateContextFactory;
import net.pterodactylus.util.web.RedirectPage;
import net.pterodactylus.util.web.TemplatePage;

public class WebInterface
implements SessionProvider {
    private static final Logger logger = Logger.getLogger(WebInterface.class.getName());
    private final Loaders loaders;
    private final NotificationManager notificationManager;
    private final SonePlugin sonePlugin;
    private final String formPassword;
    private final TemplateContextFactory templateContextFactory;
    private final TemplateRenderer templateRenderer;
    private final ParserFilter parserFilter;
    private final ShortenFilter shortenFilter;
    private final RenderFilter renderFilter;
    private final ListNotificationFilter listNotificationFilter;
    private final PostVisibilityFilter postVisibilityFilter;
    private final ReplyVisibilityFilter replyVisibilityFilter;
    private final ElementLoader elementLoader;
    private final LinkedElementRenderFilter linkedElementRenderFilter;
    private final TimeTextConverter timeTextConverter = new TimeTextConverter();
    private final L10nFilter l10nFilter;
    private final PageToadletRegistry pageToadletRegistry;
    private final MetricRegistry metricRegistry;
    private final Translation translation;
    private final SessionProvider sessionProvider;
    private final ListNotification<Post> newPostNotification;
    private final ListNotification<PostReply> newReplyNotification;
    private final ListNotification<Post> localPostNotification;
    private final ListNotification<PostReply> localReplyNotification;

    @Inject
    public WebInterface(SonePlugin sonePlugin, Loaders loaders, ListNotificationFilter listNotificationFilter, PostVisibilityFilter postVisibilityFilter, ReplyVisibilityFilter replyVisibilityFilter, ElementLoader elementLoader, TemplateContextFactory templateContextFactory, TemplateRenderer templateRenderer, ParserFilter parserFilter, ShortenFilter shortenFilter, RenderFilter renderFilter, LinkedElementRenderFilter linkedElementRenderFilter, PageToadletRegistry pageToadletRegistry, MetricRegistry metricRegistry, Translation translation, L10nFilter l10nFilter, NotificationManager notificationManager, SessionProvider sessionProvider, @Named(value="newRemotePost") ListNotification<Post> newPostNotification, @Named(value="newRemotePostReply") ListNotification<PostReply> newReplyNotification, @Named(value="localPost") ListNotification<Post> localPostNotification, @Named(value="localReply") ListNotification<PostReply> localReplyNotification) {
        this.sonePlugin = sonePlugin;
        this.loaders = loaders;
        this.listNotificationFilter = listNotificationFilter;
        this.postVisibilityFilter = postVisibilityFilter;
        this.replyVisibilityFilter = replyVisibilityFilter;
        this.elementLoader = elementLoader;
        this.templateRenderer = templateRenderer;
        this.parserFilter = parserFilter;
        this.shortenFilter = shortenFilter;
        this.renderFilter = renderFilter;
        this.linkedElementRenderFilter = linkedElementRenderFilter;
        this.pageToadletRegistry = pageToadletRegistry;
        this.metricRegistry = metricRegistry;
        this.l10nFilter = l10nFilter;
        this.translation = translation;
        this.notificationManager = notificationManager;
        this.sessionProvider = sessionProvider;
        this.newPostNotification = newPostNotification;
        this.newReplyNotification = newReplyNotification;
        this.localPostNotification = localPostNotification;
        this.localReplyNotification = localReplyNotification;
        this.formPassword = sonePlugin.pluginRespirator().getToadletContainer().getFormPassword();
        this.templateContextFactory = templateContextFactory;
        templateContextFactory.addTemplateObject("webInterface", this);
        templateContextFactory.addTemplateObject("formPassword", this.formPassword);
    }

    @Nonnull
    public Core getCore() {
        return this.sonePlugin.core();
    }

    public TemplateContextFactory getTemplateContextFactory() {
        return this.templateContextFactory;
    }

    @Override
    @Nullable
    public Sone getCurrentSone(@Nonnull ToadletContext toadletContext) {
        return this.sessionProvider.getCurrentSone(toadletContext);
    }

    @Override
    public void setCurrentSone(@Nonnull ToadletContext toadletContext, @Nullable Sone sone) {
        this.sessionProvider.setCurrentSone(toadletContext, sone);
    }

    public NotificationManager getNotifications() {
        return this.notificationManager;
    }

    @Nonnull
    public Optional<Notification> getNotification(@Nonnull String notificationId) {
        return Optional.fromNullable(this.notificationManager.getNotification(notificationId));
    }

    @Nonnull
    public Collection<Notification> getNotifications(@Nullable Sone currentSone) {
        return this.listNotificationFilter.filterNotifications(this.notificationManager.getNotifications(), currentSone);
    }

    public Translation getTranslation() {
        return this.translation;
    }

    public String getFormPassword() {
        return this.formPassword;
    }

    @Nonnull
    public Collection<Post> getNewPosts(@Nullable Sone currentSone) {
        ImmutableCollection allNewPosts = ((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().addAll(this.newPostNotification.getElements())).addAll(this.localPostNotification.getElements())).build();
        return FluentIterable.from(allNewPosts).filter(this.postVisibilityFilter.isVisible(currentSone)).toSet();
    }

    @Nonnull
    public Collection<PostReply> getNewReplies(@Nullable Sone currentSone) {
        ImmutableCollection allNewReplies = ((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().addAll(this.newReplyNotification.getElements())).addAll(this.localReplyNotification.getElements())).build();
        return FluentIterable.from(allNewReplies).filter(this.replyVisibilityFilter.isVisible(currentSone)).toSet();
    }

    public void start() {
        this.registerToadlets();
    }

    public void stop() {
        this.pageToadletRegistry.unregisterToadlets();
    }

    private void registerToadlets() {
        Template postTemplate = this.loaders.loadTemplate("/templates/include/viewPost.html");
        Template replyTemplate = this.loaders.loadTemplate("/templates/include/viewReply.html");
        Template openSearchTemplate = this.loaders.loadTemplate("/templates/xml/OpenSearch.xml");
        this.pageToadletRegistry.addPage(new RedirectPage<FreenetRequest>("", "index.html"));
        this.pageToadletRegistry.addPage(new IndexPage(this, this.loaders, this.templateRenderer, this.postVisibilityFilter));
        this.pageToadletRegistry.addPage(new NewPage(this, this.loaders, this.templateRenderer));
        this.pageToadletRegistry.addPage(new CreateSonePage(this, this.loaders, this.templateRenderer));
        this.pageToadletRegistry.addPage(new KnownSonesPage(this, this.loaders, this.templateRenderer));
        this.pageToadletRegistry.addPage(new EditProfilePage(this, this.loaders, this.templateRenderer));
        this.pageToadletRegistry.addPage(new EditProfileFieldPage(this, this.loaders, this.templateRenderer));
        this.pageToadletRegistry.addPage(new DeleteProfileFieldPage(this, this.loaders, this.templateRenderer));
        this.pageToadletRegistry.addPage(new CreatePostPage(this, this.loaders, this.templateRenderer));
        this.pageToadletRegistry.addPage(new CreateReplyPage(this, this.loaders, this.templateRenderer));
        this.pageToadletRegistry.addPage(new ViewSonePage(this, this.loaders, this.templateRenderer));
        this.pageToadletRegistry.addPage(new ViewPostPage(this, this.loaders, this.templateRenderer));
        this.pageToadletRegistry.addPage(new LikePage(this, this.loaders, this.templateRenderer));
        this.pageToadletRegistry.addPage(new UnlikePage(this, this.loaders, this.templateRenderer));
        this.pageToadletRegistry.addPage(new DeletePostPage(this, this.loaders, this.templateRenderer));
        this.pageToadletRegistry.addPage(new DeleteReplyPage(this, this.loaders, this.templateRenderer));
        this.pageToadletRegistry.addPage(new LockSonePage(this, this.loaders, this.templateRenderer));
        this.pageToadletRegistry.addPage(new UnlockSonePage(this, this.loaders, this.templateRenderer));
        this.pageToadletRegistry.addPage(new FollowSonePage(this, this.loaders, this.templateRenderer));
        this.pageToadletRegistry.addPage(new UnfollowSonePage(this, this.loaders, this.templateRenderer));
        this.pageToadletRegistry.addPage(new ImageBrowserPage(this, this.loaders, this.templateRenderer));
        this.pageToadletRegistry.addPage(new CreateAlbumPage(this, this.loaders, this.templateRenderer));
        this.pageToadletRegistry.addPage(new EditAlbumPage(this, this.loaders, this.templateRenderer));
        this.pageToadletRegistry.addPage(new DeleteAlbumPage(this, this.loaders, this.templateRenderer));
        this.pageToadletRegistry.addPage(new UploadImagePage(this, this.loaders, this.templateRenderer));
        this.pageToadletRegistry.addPage(new EditImagePage(this, this.loaders, this.templateRenderer));
        this.pageToadletRegistry.addPage(new DeleteImagePage(this, this.loaders, this.templateRenderer));
        this.pageToadletRegistry.addPage(new MarkAsKnownPage(this, this.loaders, this.templateRenderer));
        this.pageToadletRegistry.addPage(new BookmarkPage(this, this.loaders, this.templateRenderer));
        this.pageToadletRegistry.addPage(new UnbookmarkPage(this, this.loaders, this.templateRenderer));
        this.pageToadletRegistry.addPage(new BookmarksPage(this, this.loaders, this.templateRenderer));
        this.pageToadletRegistry.addPage(new SearchPage(this, this.loaders, this.templateRenderer));
        this.pageToadletRegistry.addPage(new DeleteSonePage(this, this.loaders, this.templateRenderer));
        this.pageToadletRegistry.addPage(new LoginPage(this, this.loaders, this.templateRenderer));
        this.pageToadletRegistry.addPage(new LogoutPage(this, this.loaders, this.templateRenderer));
        this.pageToadletRegistry.addPage(new OptionsPage(this, this.loaders, this.templateRenderer));
        this.pageToadletRegistry.addPage(new RescuePage(this, this.loaders, this.templateRenderer));
        this.pageToadletRegistry.addPage(new AboutPage(this, this.loaders, this.templateRenderer, new PluginVersion(SonePlugin.getPluginVersion()), new PluginYear(this.sonePlugin.getYear()), new PluginHomepage(this.sonePlugin.getHomepage())));
        this.pageToadletRegistry.addPage(new InvalidPage(this, this.loaders, this.templateRenderer));
        this.pageToadletRegistry.addPage(new NoPermissionPage(this, this.loaders, this.templateRenderer));
        this.pageToadletRegistry.addPage(new EmptyImageTitlePage(this, this.loaders, this.templateRenderer));
        this.pageToadletRegistry.addPage(new EmptyAlbumTitlePage(this, this.loaders, this.templateRenderer));
        this.pageToadletRegistry.addPage(new DismissNotificationPage(this, this.loaders, this.templateRenderer));
        this.pageToadletRegistry.addPage(new DebugPage(this, this.loaders, this.templateRenderer));
        this.pageToadletRegistry.addDebugPage(new MetricsPage(this, this.loaders, this.templateRenderer, this.metricRegistry));
        this.pageToadletRegistry.addPage(this.loaders.loadStaticPage("css/", "/static/css/", "text/css"));
        this.pageToadletRegistry.addPage(this.loaders.loadStaticPage("javascript/", "/static/javascript/", "text/javascript"));
        this.pageToadletRegistry.addPage(this.loaders.loadStaticPage("images/", "/static/images/", "image/png"));
        this.pageToadletRegistry.addPage(new TemplatePage<FreenetRequest>("OpenSearch.xml", "application/opensearchdescription+xml", this.templateContextFactory, openSearchTemplate));
        this.pageToadletRegistry.addPage(new GetImagePage(this));
        this.pageToadletRegistry.addPage(new GetTranslationAjaxPage(this));
        this.pageToadletRegistry.addPage(new GetStatusAjaxPage(this, this.elementLoader, this.timeTextConverter, this.l10nFilter, TimeZone.getDefault()));
        this.pageToadletRegistry.addPage(new GetNotificationsAjaxPage(this));
        this.pageToadletRegistry.addPage(new DismissNotificationAjaxPage(this));
        this.pageToadletRegistry.addPage(new CreatePostAjaxPage(this));
        this.pageToadletRegistry.addPage(new CreateReplyAjaxPage(this));
        this.pageToadletRegistry.addPage(new GetReplyAjaxPage(this, replyTemplate));
        this.pageToadletRegistry.addPage(new GetPostAjaxPage(this, postTemplate));
        this.pageToadletRegistry.addPage(new GetLinkedElementAjaxPage(this, this.elementLoader, this.linkedElementRenderFilter));
        this.pageToadletRegistry.addPage(new GetTimesAjaxPage(this, this.timeTextConverter, this.l10nFilter, TimeZone.getDefault()));
        this.pageToadletRegistry.addPage(new MarkAsKnownAjaxPage(this));
        this.pageToadletRegistry.addPage(new DeletePostAjaxPage(this));
        this.pageToadletRegistry.addPage(new DeleteReplyAjaxPage(this));
        this.pageToadletRegistry.addPage(new LockSoneAjaxPage(this));
        this.pageToadletRegistry.addPage(new UnlockSoneAjaxPage(this));
        this.pageToadletRegistry.addPage(new FollowSoneAjaxPage(this));
        this.pageToadletRegistry.addPage(new UnfollowSoneAjaxPage(this));
        this.pageToadletRegistry.addPage(new EditAlbumAjaxPage(this));
        this.pageToadletRegistry.addPage(new EditImageAjaxPage(this, this.parserFilter, this.shortenFilter, this.renderFilter));
        this.pageToadletRegistry.addPage(new LikeAjaxPage(this));
        this.pageToadletRegistry.addPage(new UnlikeAjaxPage(this));
        this.pageToadletRegistry.addPage(new GetLikesAjaxPage(this));
        this.pageToadletRegistry.addPage(new BookmarkAjaxPage(this));
        this.pageToadletRegistry.addPage(new UnbookmarkAjaxPage(this));
        this.pageToadletRegistry.addPage(new EditProfileFieldAjaxPage(this));
        this.pageToadletRegistry.addPage(new DeleteProfileFieldAjaxPage(this));
        this.pageToadletRegistry.addPage(new MoveProfileFieldAjaxPage(this));
        this.pageToadletRegistry.registerToadlets();
    }

    @Subscribe
    public void debugActivated(@Nonnull DebugActivatedEvent debugActivatedEvent) {
        this.pageToadletRegistry.activateDebugMode();
    }
}

