/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.sone.text;

import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.pterodactylus.sone.freenet.L10nText;
import net.pterodactylus.sone.text.TimeText;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\n\u0018\u00002\u00020\u0001B\u0015\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0004J\f\u0010\t\u001a\u00020\u0004*\u00020\nH\u0002J\f\u0010\u000b\u001a\u00020\u0004*\u00020\nH\u0002J\f\u0010\f\u001a\u00020\u0004*\u00020\nH\u0002J\f\u0010\r\u001a\u00020\u0004*\u00020\nH\u0002J\f\u0010\u000e\u001a\u00020\u0004*\u00020\u0004H\u0002J\f\u0010\u000f\u001a\u00020\u0004*\u00020\u0004H\u0002J\f\u0010\u0010\u001a\u00020\u0004*\u00020\u0004H\u0002J\f\u0010\u0011\u001a\u00020\u0004*\u00020\u0004H\u0002J\f\u0010\u0012\u001a\u00020\u0004*\u00020\u0004H\u0002J\f\u0010\u0013\u001a\u00020\u0004*\u00020\u0004H\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lnet/pterodactylus/sone/text/TimeTextConverter;", "", "timeSuppler", "Lkotlin/Function0;", "", "(Lkotlin/jvm/functions/Function0;)V", "getTimeText", "Lnet/pterodactylus/sone/text/TimeText;", "time", "days", "", "hours", "minutes", "seconds", "toDays", "toHours", "toMinutes", "toMonths", "toWeeks", "toYears", "Sone"})
public final class TimeTextConverter {
    private final Function0<Long> timeSuppler;

    @NotNull
    public final TimeText getTimeText(long time) {
        long age = ((Number)this.timeSuppler.invoke()).longValue() - time;
        return time == 0L ? new TimeText(new L10nText("View.Sone.Text.UnknownDate", null, 2, null), this.hours(12)) : (age < 0L ? new TimeText(new L10nText("View.Time.InTheFuture", null, 2, null), this.minutes(5)) : (age < this.seconds(20) ? new TimeText(new L10nText("View.Time.AFewSecondsAgo", null, 2, null), this.seconds(10)) : (age < this.seconds(45) ? new TimeText(new L10nText("View.Time.HalfAMinuteAgo", null, 2, null), this.seconds(20)) : (age < this.seconds(90) ? new TimeText(new L10nText("View.Time.AMinuteAgo", null, 2, null), this.minutes(1)) : (age < this.minutes(30) ? new TimeText(new L10nText("View.Time.XMinutesAgo", CollectionsKt.listOf(this.toMinutes(age + this.seconds(30)))), this.minutes(1)) : (age < this.minutes(45) ? new TimeText(new L10nText("View.Time.HalfAnHourAgo", null, 2, null), this.minutes(10)) : (age < this.minutes(90) ? new TimeText(new L10nText("View.Time.AnHourAgo", null, 2, null), this.hours(1)) : (age < this.hours(21) ? new TimeText(new L10nText("View.Time.XHoursAgo", CollectionsKt.listOf(this.toHours(age + this.minutes(30)))), this.hours(1)) : (age < this.hours(42) ? new TimeText(new L10nText("View.Time.ADayAgo", null, 2, null), this.days(1)) : (age < this.days(6) ? new TimeText(new L10nText("View.Time.XDaysAgo", CollectionsKt.listOf(this.toDays(age + this.hours(12)))), this.days(1)) : (age < this.days(11) ? new TimeText(new L10nText("View.Time.AWeekAgo", null, 2, null), this.days(1)) : (age < this.days(28) ? new TimeText(new L10nText("View.Time.XWeeksAgo", CollectionsKt.listOf(this.toWeeks(age + this.days(3) + this.hours(12)))), this.days(1)) : (age < this.days(42) ? new TimeText(new L10nText("View.Time.AMonthAgo", null, 2, null), this.days(1)) : (age < this.days(330) ? new TimeText(new L10nText("View.Time.XMonthsAgo", CollectionsKt.listOf(this.toMonths(age + this.days(15)))), this.days(1)) : (age < this.days(540) ? new TimeText(new L10nText("View.Time.AYearAgo", null, 2, null), this.days(7)) : new TimeText(new L10nText("View.Time.XYearsAgo", CollectionsKt.listOf(this.toYears(age + this.days(182) + this.hours(12)))), this.days(7)))))))))))))))));
    }

    private final long toMinutes(long $this$toMinutes) {
        return TimeUnit.MILLISECONDS.toMinutes($this$toMinutes);
    }

    private final long toHours(long $this$toHours) {
        return TimeUnit.MILLISECONDS.toHours($this$toHours);
    }

    private final long toDays(long $this$toDays) {
        return TimeUnit.MILLISECONDS.toDays($this$toDays);
    }

    private final long toWeeks(long $this$toWeeks) {
        return TimeUnit.MILLISECONDS.toDays($this$toWeeks) / (long)7;
    }

    private final long toMonths(long $this$toMonths) {
        return TimeUnit.MILLISECONDS.toDays($this$toMonths) / (long)30;
    }

    private final long toYears(long $this$toYears) {
        return TimeUnit.MILLISECONDS.toDays($this$toYears) / (long)365;
    }

    private final long seconds(int $this$seconds) {
        return TimeUnit.SECONDS.toMillis($this$seconds);
    }

    private final long minutes(int $this$minutes) {
        return TimeUnit.MINUTES.toMillis($this$minutes);
    }

    private final long hours(int $this$hours) {
        return TimeUnit.HOURS.toMillis($this$hours);
    }

    private final long days(int $this$days) {
        return TimeUnit.DAYS.toMillis($this$days);
    }

    public TimeTextConverter(@NotNull Function0<Long> timeSuppler) {
        Intrinsics.checkParameterIsNotNull(timeSuppler, "timeSuppler");
        this.timeSuppler = timeSuppler;
    }

    public /* synthetic */ TimeTextConverter(Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            function0 = 1.INSTANCE;
        }
        this(function0);
    }

    public TimeTextConverter() {
        this(null, 1, null);
    }
}

