/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.sone.template;

import java.util.logging.Level;
import java.util.logging.Logger;
import net.pterodactylus.sone.core.Core;
import net.pterodactylus.sone.data.Profile;
import net.pterodactylus.sone.data.Sone;
import net.pterodactylus.sone.data.SoneKt;
import net.pterodactylus.sone.freenet.wot.OwnIdentity;
import net.pterodactylus.sone.freenet.wot.Trust;
import net.pterodactylus.sone.text.TimeTextConverter;
import net.pterodactylus.util.template.ReflectionAccessor;
import net.pterodactylus.util.template.TemplateContext;

public class SoneAccessor
extends ReflectionAccessor {
    private static final Logger logger = Logger.getLogger(SoneAccessor.class.getName());
    private final Core core;
    private final TimeTextConverter timeTextConverter;

    public SoneAccessor(Core core, TimeTextConverter timeTextConverter) {
        this.core = core;
        this.timeTextConverter = timeTextConverter;
    }

    @Override
    public Object get(TemplateContext templateContext, Object object, String member) {
        Sone sone = (Sone)object;
        if (member.equals("niceName")) {
            return SoneAccessor.getNiceName(sone);
        }
        if (member.equals("friend")) {
            Sone currentSone = (Sone)templateContext.get("currentSone");
            return currentSone != null && currentSone.hasFriend(sone.getId());
        }
        if (member.equals("current")) {
            Sone currentSone = (Sone)templateContext.get("currentSone");
            return currentSone != null && currentSone.equals(sone);
        }
        if (member.equals("modified")) {
            return this.core.isModifiedSone(sone);
        }
        if (member.equals("status")) {
            return sone.getStatus();
        }
        if (member.equals("unknown")) {
            return sone.getStatus() == Sone.SoneStatus.unknown;
        }
        if (member.equals("idle")) {
            return sone.getStatus() == Sone.SoneStatus.idle;
        }
        if (member.equals("inserting")) {
            return sone.getStatus() == Sone.SoneStatus.inserting;
        }
        if (member.equals("downloading")) {
            return sone.getStatus() == Sone.SoneStatus.downloading;
        }
        if (member.equals("new")) {
            return !sone.isKnown();
        }
        if (member.equals("locked")) {
            return this.core.isLocked(sone);
        }
        if (member.equals("lastUpdatedText")) {
            return this.timeTextConverter.getTimeText(sone.getTime()).getL10nText();
        }
        if (member.equals("trust")) {
            Sone currentSone = (Sone)templateContext.get("currentSone");
            if (currentSone == null) {
                return null;
            }
            Trust trust = sone.getIdentity().getTrust((OwnIdentity)currentSone.getIdentity());
            logger.log(Level.FINEST, String.format("Trust for %s by %s: %s", sone, currentSone, trust));
            if (trust == null) {
                return new Trust(null, null, null);
            }
            return trust;
        }
        if (member.equals("allImages")) {
            return SoneKt.getAllImages(sone);
        }
        if (member.equals("albums")) {
            return sone.getRootAlbum().getAlbums();
        }
        return super.get(templateContext, object, member);
    }

    public static String getNiceName(Sone sone) {
        Profile profile = sone.getProfile();
        String firstName = profile.getFirstName();
        String middleName = profile.getMiddleName();
        String lastName = profile.getLastName();
        if (firstName == null) {
            if (lastName == null) {
                return String.valueOf(sone.getName());
            }
            return lastName;
        }
        return firstName + (middleName != null ? " " + middleName : "") + (lastName != null ? " " + lastName : "");
    }
}

