/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.sone.template;

import net.pterodactylus.sone.core.Core;
import net.pterodactylus.sone.data.Profile;
import net.pterodactylus.sone.data.Sone;
import net.pterodactylus.sone.data.SoneOptions;
import net.pterodactylus.sone.freenet.wot.OwnIdentity;
import net.pterodactylus.sone.freenet.wot.Trust;
import net.pterodactylus.util.template.ReflectionAccessor;
import net.pterodactylus.util.template.TemplateContext;

public class ProfileAccessor
extends ReflectionAccessor {
    private final Core core;

    public ProfileAccessor(Core core) {
        this.core = core;
    }

    @Override
    public Object get(TemplateContext templateContext, Object object, String member) {
        Profile profile = (Profile)object;
        if ("avatar".equals(member)) {
            Sone currentSone = (Sone)templateContext.get("currentSone");
            if (currentSone == null) {
                return null;
            }
            String avatarId = profile.getAvatar();
            if (avatarId == null) {
                return null;
            }
            if (this.core.getImage(avatarId, false) == null) {
                return null;
            }
            Sone remoteSone = profile.getSone();
            if (remoteSone.isLocal()) {
                return avatarId;
            }
            SoneOptions.LoadExternalContent showCustomAvatars = currentSone.getOptions().getShowCustomAvatars();
            if (showCustomAvatars == SoneOptions.LoadExternalContent.NEVER) {
                return null;
            }
            if (showCustomAvatars == SoneOptions.LoadExternalContent.ALWAYS) {
                return avatarId;
            }
            if (showCustomAvatars == SoneOptions.LoadExternalContent.FOLLOWED) {
                return currentSone.hasFriend(remoteSone.getId()) ? avatarId : null;
            }
            Trust trust = remoteSone.getIdentity().getTrust((OwnIdentity)currentSone.getIdentity());
            if (trust == null) {
                return null;
            }
            if (showCustomAvatars == SoneOptions.LoadExternalContent.MANUALLY_TRUSTED && trust.getExplicit() != null && trust.getExplicit() > 0) {
                return avatarId;
            }
            if (showCustomAvatars == SoneOptions.LoadExternalContent.TRUSTED && (trust.getExplicit() != null && trust.getExplicit() > 0 || trust.getImplicit() != null && trust.getImplicit() > 0)) {
                return avatarId;
            }
            return null;
        }
        return super.get(templateContext, object, member);
    }
}

