/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.sone.template;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Map;
import net.pterodactylus.sone.core.Core;
import net.pterodactylus.sone.data.Image;
import net.pterodactylus.sone.template.CssClassNameFilter;
import net.pterodactylus.sone.utils.NumberParsers;
import net.pterodactylus.util.template.Filter;
import net.pterodactylus.util.template.HtmlFilter;
import net.pterodactylus.util.template.Template;
import net.pterodactylus.util.template.TemplateContext;
import net.pterodactylus.util.template.TemplateContextFactory;
import net.pterodactylus.util.template.TemplateParser;

public class ImageLinkFilter
implements Filter {
    private static final Template linkTemplate = TemplateParser.parse(new StringReader("<img<%ifnull !class> class=\"<%class|css>\"<%/if> src=\"<%src|html>\" alt=\"<%alt|html>\" title=\"<%title|html>\" width=\"<%width|html>\" height=\"<%height|html>\" style=\"position: relative;<%ifnull ! top>top: <% top|html>;<%/if><%ifnull ! left>left: <% left|html>;<%/if>\"/>"));
    private final Core core;
    private final TemplateContextFactory templateContextFactory = new TemplateContextFactory();

    public ImageLinkFilter(Core core) {
        this.core = core;
        this.templateContextFactory.addFilter("html", new HtmlFilter());
        this.templateContextFactory.addFilter("css", new CssClassNameFilter());
    }

    @Override
    public Object format(TemplateContext templateContext, Object data, Map<String, Object> parameters2) {
        double scale;
        Image image = null;
        if (data instanceof String) {
            image = this.core.getImage((String)data, false);
        } else if (data instanceof Image) {
            image = (Image)data;
        }
        if (image == null) {
            return null;
        }
        String imageClass = Optional.fromNullable(parameters2.get("class")).transform(this.getStringValue()).orNull();
        int maxWidth = NumberParsers.parseInt(String.valueOf(parameters2.get("max-width")), Integer.MAX_VALUE);
        int maxHeight = NumberParsers.parseInt(String.valueOf(parameters2.get("max-height")), Integer.MAX_VALUE);
        String mode = String.valueOf(parameters2.get("mode"));
        String title = Optional.fromNullable(parameters2.get("title")).transform(this.getStringValue()).orNull();
        TemplateContext linkTemplateContext = this.templateContextFactory.createTemplateContext();
        linkTemplateContext.set("class", imageClass);
        if (image.isInserted()) {
            linkTemplateContext.set("src", "/" + image.getKey());
        } else {
            linkTemplateContext.set("src", "getImage.html?image=" + image.getId());
        }
        int imageWidth = image.getWidth();
        int imageHeight = image.getHeight();
        if ("enlarge".equals(mode)) {
            scale = Math.max((double)maxWidth / (double)imageWidth, (double)maxHeight / (double)imageHeight);
            linkTemplateContext.set("width", (int)((double)imageWidth * scale + 0.5));
            linkTemplateContext.set("height", (int)((double)imageHeight * scale + 0.5));
            linkTemplateContext.set("left", String.format("%dpx", (int)((double)maxWidth - (double)imageWidth * scale) / 2));
            linkTemplateContext.set("top", String.format("%dpx", (int)((double)maxHeight - (double)imageHeight * scale) / 2));
        } else {
            scale = 1.0;
            if (imageWidth > maxWidth || imageHeight > maxHeight) {
                scale = Math.min((double)maxWidth / (double)imageWidth, (double)maxHeight / (double)imageHeight);
            }
            linkTemplateContext.set("width", (int)((double)imageWidth * scale + 0.5));
            linkTemplateContext.set("height", (int)((double)imageHeight * scale + 0.5));
        }
        linkTemplateContext.set("alt", Optional.fromNullable(title).or(image.getDescription()));
        linkTemplateContext.set("title", Optional.fromNullable(title).or(image.getTitle()));
        StringWriter stringWriter = new StringWriter();
        linkTemplate.render(linkTemplateContext, stringWriter);
        return stringWriter.toString();
    }

    private Function<Object, String> getStringValue() {
        return new Function<Object, String>(){

            @Override
            public String apply(Object input) {
                return input != null ? input.toString() : null;
            }
        };
    }
}

