/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.sone.template;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.pterodactylus.sone.data.Album;
import net.pterodactylus.sone.data.Image;
import net.pterodactylus.sone.template.SoneAccessor;
import net.pterodactylus.util.template.ReflectionAccessor;
import net.pterodactylus.util.template.TemplateContext;

public class AlbumAccessor
extends ReflectionAccessor {
    private final Random random = new Random();

    @Override
    public Object get(TemplateContext templateContext, Object object, String member) {
        Album album = (Album)object;
        if ("backlinks".equals(member)) {
            ArrayList<Link> backlinks = new ArrayList<Link>();
            Album currentAlbum = album;
            while (!currentAlbum.isRoot()) {
                backlinks.add(0, new Link("imageBrowser.html?album=" + currentAlbum.getId(), currentAlbum.getTitle()));
                currentAlbum = currentAlbum.getParent();
            }
            backlinks.add(0, new Link("imageBrowser.html?sone=" + album.getSone().getId(), SoneAccessor.getNiceName(album.getSone())));
            return backlinks;
        }
        if ("albumImage".equals(member)) {
            List<Image> images = album.getImages();
            return images.isEmpty() ? null : images.get(this.random.nextInt(images.size()));
        }
        return super.get(templateContext, object, member);
    }

    private static class Link {
        private final String target;
        private final String name;

        private Link(String target, String name) {
            this.target = target;
            this.name = name;
        }

        public String getTarget() {
            return this.target;
        }

        public String getName() {
            return this.name;
        }
    }
}

