/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.sone.notify;

import com.google.common.base.Optional;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.pterodactylus.sone.data.Identified;
import net.pterodactylus.sone.data.Post;
import net.pterodactylus.sone.data.PostReply;
import net.pterodactylus.sone.data.Sone;
import net.pterodactylus.sone.notify.ListNotification;
import net.pterodactylus.sone.notify.PostVisibilityFilter;
import net.pterodactylus.sone.notify.ReplyVisibilityFilter;
import net.pterodactylus.util.notify.Notification;

@Singleton
public class ListNotificationFilter {
    private final PostVisibilityFilter postVisibilityFilter;
    private final ReplyVisibilityFilter replyVisibilityFilter;

    @Inject
    public ListNotificationFilter(@Nonnull PostVisibilityFilter postVisibilityFilter, @Nonnull ReplyVisibilityFilter replyVisibilityFilter) {
        this.postVisibilityFilter = postVisibilityFilter;
        this.replyVisibilityFilter = replyVisibilityFilter;
    }

    public List<Notification> filterNotifications(Collection<? extends Notification> notifications, Sone currentSone) {
        ArrayList<Notification> filteredNotifications = new ArrayList<Notification>();
        for (Notification notification : notifications) {
            Optional<ListNotification<Identified>> filteredNotification;
            if (notification.getId().equals("new-sone-notification")) {
                if (currentSone != null && !currentSone.getOptions().isShowNewSoneNotifications()) continue;
                filteredNotifications.add(notification);
                continue;
            }
            if (notification.getId().equals("new-post-notification")) {
                if (currentSone == null || !currentSone.getOptions().isShowNewPostNotifications() || !(filteredNotification = this.filterPostNotification((ListNotification)notification, currentSone)).isPresent()) continue;
                filteredNotifications.add(filteredNotification.get());
                continue;
            }
            if (notification.getId().equals("new-reply-notification")) {
                if (currentSone == null || !currentSone.getOptions().isShowNewReplyNotifications() || !(filteredNotification = this.filterNewReplyNotification((ListNotification)notification, currentSone)).isPresent()) continue;
                filteredNotifications.add(filteredNotification.get());
                continue;
            }
            if (notification.getId().equals("mention-notification")) {
                filteredNotification = this.filterPostNotification((ListNotification)notification, null);
                if (!filteredNotification.isPresent()) continue;
                filteredNotifications.add(filteredNotification.get());
                continue;
            }
            filteredNotifications.add(notification);
        }
        return filteredNotifications;
    }

    @Nonnull
    private Optional<ListNotification<Post>> filterPostNotification(@Nonnull ListNotification<Post> postNotification, @Nullable Sone currentSone) {
        ImmutableList<Post> newPosts = FluentIterable.from(postNotification.getElements()).filter(this.postVisibilityFilter.isVisible(currentSone)).toList();
        if (newPosts.isEmpty()) {
            return Optional.absent();
        }
        if (newPosts.size() == postNotification.getElements().size()) {
            return Optional.of(postNotification);
        }
        ListNotification<Post> filteredNotification = new ListNotification<Post>(postNotification);
        filteredNotification.setElements(newPosts);
        filteredNotification.setLastUpdateTime(postNotification.getLastUpdatedTime());
        return Optional.of(filteredNotification);
    }

    private Optional<ListNotification<PostReply>> filterNewReplyNotification(ListNotification<PostReply> newReplyNotification, @Nonnull Sone currentSone) {
        ImmutableList<PostReply> newReplies = FluentIterable.from(newReplyNotification.getElements()).filter(this.replyVisibilityFilter.isVisible(currentSone)).toList();
        if (newReplies.isEmpty()) {
            return Optional.absent();
        }
        if (newReplies.size() == newReplyNotification.getElements().size()) {
            return Optional.of(newReplyNotification);
        }
        ListNotification<PostReply> filteredNotification = new ListNotification<PostReply>(newReplyNotification);
        filteredNotification.setElements(newReplies);
        filteredNotification.setLastUpdateTime(newReplyNotification.getLastUpdatedTime());
        return Optional.of(filteredNotification);
    }
}

