/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.sone.notify;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.pterodactylus.util.notify.TemplateNotification;
import net.pterodactylus.util.template.Template;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B)\b\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nB\u0015\b\u0016\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000\u00a2\u0006\u0002\u0010\fJ\u0013\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0018J\b\u0010\u0019\u001a\u00020\u0016H\u0016J\u0013\u0010\u001a\u001a\u00020\t2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0096\u0002J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\u0013\u0010\u001f\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0018J\u0014\u0010 \u001a\u00020\u00162\f\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000!R\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lnet/pterodactylus/sone/notify/ListNotification;", "T", "Lnet/pterodactylus/util/notify/TemplateNotification;", "id", "", "key", "template", "Lnet/pterodactylus/util/template/Template;", "dismissable", "", "(Ljava/lang/String;Ljava/lang/String;Lnet/pterodactylus/util/template/Template;Z)V", "listNotification", "(Lnet/pterodactylus/sone/notify/ListNotification;)V", "elements", "", "getElements", "()Ljava/util/List;", "isEmpty", "()Z", "realElements", "Ljava/util/concurrent/CopyOnWriteArrayList;", "add", "", "element", "(Ljava/lang/Object;)V", "dismiss", "equals", "other", "", "hashCode", "", "remove", "setElements", "", "Sone"})
public final class ListNotification<T>
extends TemplateNotification {
    private final String key;
    private final CopyOnWriteArrayList<T> realElements;

    @NotNull
    public final List<T> getElements() {
        return CollectionsKt.toList((Iterable)this.realElements);
    }

    public final boolean isEmpty() {
        return this.getElements().isEmpty();
    }

    public final void setElements(@NotNull Collection<? extends T> elements) {
        Intrinsics.checkParameterIsNotNull(elements, "elements");
        this.realElements.clear();
        this.realElements.addAll(CollectionsKt.distinct((Iterable)elements));
        this.touch();
    }

    public final void add(T element) {
        if (!this.realElements.contains(element)) {
            this.realElements.add(element);
            this.touch();
        }
    }

    public final void remove(T element) {
        while (this.realElements.remove(element)) {
        }
        if (this.realElements.isEmpty()) {
            this.dismiss();
        }
        this.touch();
    }

    @Override
    public void dismiss() {
        super.dismiss();
        this.realElements.clear();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int hashCode() {
        void $this$fold$iv;
        Iterable iterable = this.realElements;
        int initial$iv = super.hashCode();
        boolean $i$f$fold = false;
        int accumulator$iv = initial$iv;
        Iterator iterator2 = $this$fold$iv.iterator();
        while (iterator2.hasNext()) {
            void element;
            Object element$iv;
            Object t = element$iv = iterator2.next();
            int hash = accumulator$iv;
            boolean bl = false;
            void var10_10 = element;
            int n = hash;
            boolean bl2 = false;
            void v0 = var10_10;
            int n2 = v0 != null ? v0.hashCode() : 0;
            accumulator$iv = n ^ n2;
        }
        return accumulator$iv;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (!(other instanceof ListNotification)) {
            return false;
        }
        ListNotification listNotification = (ListNotification)other;
        if (!super.equals(listNotification)) {
            return false;
        }
        return Intrinsics.areEqual(this.key, listNotification.key) && Intrinsics.areEqual(this.realElements, listNotification.realElements);
    }

    @JvmOverloads
    public ListNotification(@NotNull String id, @NotNull String key, @NotNull Template template, boolean dismissable) {
        Intrinsics.checkParameterIsNotNull(id, "id");
        Intrinsics.checkParameterIsNotNull(key, "key");
        Intrinsics.checkParameterIsNotNull(template, "template");
        super(id, System.currentTimeMillis(), System.currentTimeMillis(), dismissable, template);
        this.realElements = new CopyOnWriteArrayList();
        this.key = key;
        template.getInitialContext().set(key, this.realElements);
    }

    public /* synthetic */ ListNotification(String string, String string2, Template template, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            bl = true;
        }
        this(string, string2, template, bl);
    }

    @JvmOverloads
    public ListNotification(@NotNull String id, @NotNull String key, @NotNull Template template) {
        this(id, key, template, false, 8, null);
    }

    public ListNotification(@NotNull ListNotification<T> listNotification) {
        Intrinsics.checkParameterIsNotNull(listNotification, "listNotification");
        super(listNotification.getId(), listNotification.getCreatedTime(), listNotification.getLastUpdatedTime(), listNotification.isDismissable(), new Template());
        this.realElements = new CopyOnWriteArrayList();
        this.key = listNotification.key;
        this.getTemplate().add(listNotification.getTemplate());
        Template template = this.getTemplate();
        Intrinsics.checkExpressionValueIsNotNull(template, "template");
        template.getInitialContext().set(this.key, this.realElements);
    }
}

