/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.sone.main;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.eventbus.EventBus;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.name.Names;
import freenet.l10n.BaseL10n;
import freenet.l10n.PluginL10n;
import freenet.pluginmanager.FredPlugin;
import freenet.pluginmanager.FredPluginBaseL10n;
import freenet.pluginmanager.FredPluginFCP;
import freenet.pluginmanager.FredPluginL10n;
import freenet.pluginmanager.FredPluginThreadless;
import freenet.pluginmanager.FredPluginVersioned;
import freenet.pluginmanager.PluginReplySender;
import freenet.pluginmanager.PluginRespirator;
import freenet.support.Logger;
import freenet.support.SimpleFieldSet;
import freenet.support.api.Bucket;
import java.lang.annotation.Annotation;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.annotation.Nonnull;
import kotlin.jvm.functions.Function1;
import net.pterodactylus.sone.core.Core;
import net.pterodactylus.sone.core.event.ConfigNotRead;
import net.pterodactylus.sone.core.event.FirstStart;
import net.pterodactylus.sone.core.event.Shutdown;
import net.pterodactylus.sone.core.event.Startup;
import net.pterodactylus.sone.fcp.FcpInterface;
import net.pterodactylus.sone.freenet.wot.WebOfTrustConnector;
import net.pterodactylus.sone.main.FreenetModule;
import net.pterodactylus.sone.main.SoneModule;
import net.pterodactylus.sone.main.TickerShutdown;
import net.pterodactylus.sone.main.Version;
import net.pterodactylus.sone.main.VersionParserKt;
import net.pterodactylus.sone.web.WebInterface;
import net.pterodactylus.sone.web.WebInterfaceModule;
import net.pterodactylus.sone.web.notification.NotificationHandler;
import net.pterodactylus.sone.web.notification.NotificationHandlerModule;

public class SonePlugin
implements FredPlugin,
FredPluginFCP,
FredPluginL10n,
FredPluginBaseL10n,
FredPluginThreadless,
FredPluginVersioned {
    private static final java.util.logging.Logger soneLogger = java.util.logging.Logger.getLogger("net.pterodactylus.sone");
    private static final int YEAR = 2020;
    private static final String SONE_HOMEPAGE = "USK@nwa8lHa271k2QvJ8aa0Ov7IHAV-DFOCFgmDt3X6BpCI,DuQSUZiI~agF8c-6tjsFFGuZ8eICrzWCILB60nT8KKo,AQACAAE/sone/";
    private static final int LATEST_EDITION = 81;
    private static final java.util.logging.Logger logger;
    private final Function1<Module[], Injector> injectorCreator;
    private PluginRespirator pluginRespirator;
    private Core core;
    private EventBus eventBus;
    private WebInterface webInterface;
    private FcpInterface fcpInterface;
    private PluginL10n l10n;
    private WebOfTrustConnector webOfTrustConnector;

    public SonePlugin() {
        this(Guice::createInjector);
    }

    @VisibleForTesting
    public SonePlugin(Function1<Module[], Injector> injectorCreator) {
        this.injectorCreator = injectorCreator;
    }

    public PluginRespirator pluginRespirator() {
        return this.pluginRespirator;
    }

    public Core core() {
        return this.core;
    }

    public PluginL10n l10n() {
        return this.l10n;
    }

    public static String getPluginVersion() {
        Version version = VersionParserKt.getParsedVersion();
        return version == null ? "unknown" : version.getNice();
    }

    public int getYear() {
        return 2020;
    }

    public String getHomepage() {
        return "USK@nwa8lHa271k2QvJ8aa0Ov7IHAV-DFOCFgmDt3X6BpCI,DuQSUZiI~agF8c-6tjsFFGuZ8eICrzWCILB60nT8KKo,AQACAAE/sone/81";
    }

    public static long getLatestEdition() {
        return 81L;
    }

    public void runPlugin(PluginRespirator pluginRespirator) {
        this.pluginRespirator = pluginRespirator;
        Injector injector = this.createInjector();
        this.core = injector.getInstance(Core.class);
        this.webOfTrustConnector = injector.getInstance(WebOfTrustConnector.class);
        this.fcpInterface = injector.getInstance(FcpInterface.class);
        this.webInterface = injector.getInstance(WebInterface.class);
        injector.getInstance(NotificationHandler.class);
        injector.getInstance(TickerShutdown.class);
        this.core.start();
        this.webInterface.start();
        this.eventBus = injector.getInstance(EventBus.class);
        if (injector.getInstance(Key.get(Boolean.class, (Annotation)Names.named("FirstStart"))).booleanValue()) {
            this.eventBus.post(new FirstStart());
        } else if (injector.getInstance(Key.get(Boolean.class, (Annotation)Names.named("NewConfig"))).booleanValue()) {
            this.eventBus.post(new ConfigNotRead());
        }
        this.eventBus.post(new Startup());
    }

    @VisibleForTesting
    protected Injector createInjector() {
        FreenetModule freenetModule = new FreenetModule(this.pluginRespirator);
        SoneModule soneModule = new SoneModule(this, new EventBus());
        WebInterfaceModule webInterfaceModule = new WebInterfaceModule();
        NotificationHandlerModule notificationHandlerModule = new NotificationHandlerModule();
        return this.createInjector(freenetModule, soneModule, webInterfaceModule, notificationHandlerModule);
    }

    @VisibleForTesting
    protected Injector createInjector(Module ... modules) {
        return this.injectorCreator.invoke(modules);
    }

    public void terminate() {
        this.eventBus.post(new Shutdown());
        try {
            this.webInterface.stop();
            this.core.stop();
            this.webOfTrustConnector.stop();
        }
        catch (Throwable t1) {
            logger.log(Level.SEVERE, "Error while shutting down!", t1);
        }
        finally {
            this.deregisterLoggerHandlers();
        }
    }

    private void deregisterLoggerHandlers() {
        for (Handler handler : soneLogger.getHandlers()) {
            soneLogger.removeHandler(handler);
        }
    }

    public void handle(PluginReplySender pluginReplySender, SimpleFieldSet parameters2, Bucket data, int accessType) {
        this.fcpInterface.handle(pluginReplySender, parameters2, data, accessType);
    }

    public String getString(String key) {
        return this.l10n.getBase().getString(key);
    }

    public void setLanguage(BaseL10n.LANGUAGE newLanguage) {
        this.l10n = new PluginL10n((FredPluginBaseL10n)this, newLanguage);
    }

    public String getL10nFilesBasePath() {
        return "i18n";
    }

    public String getL10nFilesMask() {
        return "sone.${lang}.properties";
    }

    public String getL10nOverrideFilesMask() {
        return "sone.${lang}.override.properties";
    }

    public ClassLoader getPluginClassLoader() {
        return SonePlugin.class.getClassLoader();
    }

    public String getVersion() {
        return SonePlugin.getPluginVersion();
    }

    static {
        soneLogger.setUseParentHandlers(false);
        soneLogger.setLevel(Level.ALL);
        soneLogger.addHandler(new Handler(){
            private final LoadingCache<String, Class<?>> classCache = CacheBuilder.newBuilder().build(new CacheLoader<String, Class<?>>(){

                @Override
                public Class<?> load(@Nonnull String key) throws Exception {
                    return SonePlugin.class.getClassLoader().loadClass(key);
                }
            });

            @Override
            public void publish(LogRecord logRecord) {
                int recordLevel = logRecord.getLevel().intValue();
                Class<?> loggingClass = this.classCache.getUnchecked(logRecord.getLoggerName());
                if (recordLevel < Level.FINE.intValue()) {
                    Logger.debug(loggingClass, (String)logRecord.getMessage(), (Throwable)logRecord.getThrown());
                } else if (recordLevel < Level.INFO.intValue()) {
                    Logger.minor(loggingClass, (String)logRecord.getMessage(), (Throwable)logRecord.getThrown());
                } else if (recordLevel < Level.WARNING.intValue()) {
                    Logger.normal(loggingClass, (String)logRecord.getMessage(), (Throwable)logRecord.getThrown());
                } else if (recordLevel < Level.SEVERE.intValue()) {
                    Logger.warning(loggingClass, (String)logRecord.getMessage(), (Throwable)logRecord.getThrown());
                } else {
                    Logger.error(loggingClass, (String)logRecord.getMessage(), (Throwable)logRecord.getThrown());
                }
            }

            @Override
            public void flush() {
            }

            @Override
            public void close() {
            }
        });
        logger = java.util.logging.Logger.getLogger(SonePlugin.class.getName());
    }
}

