/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.sone.main;

import com.codahale.metrics.MetricRegistry;
import com.google.common.base.Optional;
import com.google.common.eventbus.EventBus;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.TypeLiteral;
import com.google.inject.binder.AnnotatedBindingBuilder;
import com.google.inject.matcher.Matchers;
import com.google.inject.name.Names;
import com.google.inject.spi.InjectionListener;
import com.google.inject.spi.TypeEncounter;
import com.google.inject.spi.TypeListener;
import freenet.l10n.BaseL10n;
import freenet.l10n.PluginL10n;
import java.io.File;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Supplier;
import java.util.logging.Logger;
import javax.inject.Named;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.pterodactylus.sone.core.SoneUriCreator;
import net.pterodactylus.sone.database.Database;
import net.pterodactylus.sone.database.memory.MemoryDatabase;
import net.pterodactylus.sone.freenet.BaseL10nTranslation;
import net.pterodactylus.sone.freenet.Translation;
import net.pterodactylus.sone.freenet.wot.Context;
import net.pterodactylus.sone.freenet.wot.PluginWebOfTrustConnector;
import net.pterodactylus.sone.freenet.wot.WebOfTrustConnector;
import net.pterodactylus.sone.main.DebugLoaders;
import net.pterodactylus.sone.main.Loaders;
import net.pterodactylus.sone.main.PluginHomepage;
import net.pterodactylus.sone.main.PluginVersion;
import net.pterodactylus.sone.main.PluginYear;
import net.pterodactylus.sone.main.SoneModule;
import net.pterodactylus.sone.main.SoneModuleKt;
import net.pterodactylus.sone.main.SonePlugin;
import net.pterodactylus.sone.main.TickerShutdown;
import net.pterodactylus.sone.web.FreenetSessionProvider;
import net.pterodactylus.sone.web.SessionProvider;
import net.pterodactylus.util.config.Configuration;
import net.pterodactylus.util.config.ConfigurationException;
import net.pterodactylus.util.config.MapConfigurationBackend;
import net.pterodactylus.util.logging.Logging;
import net.pterodactylus.util.version.Version;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\t\u001a\u00020\nH\u0014J\b\u0010\u000b\u001a\u00020\fH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lnet/pterodactylus/sone/main/SoneModule;", "Lcom/google/inject/AbstractModule;", "sonePlugin", "Lnet/pterodactylus/sone/main/SonePlugin;", "eventBus", "Lcom/google/common/eventbus/EventBus;", "(Lnet/pterodactylus/sone/main/SonePlugin;Lcom/google/common/eventbus/EventBus;)V", "logger", "Ljava/util/logging/Logger;", "configure", "", "getNotificationTicker", "Ljava/util/concurrent/ScheduledExecutorService;", "Sone"})
public class SoneModule
extends AbstractModule {
    private final Logger logger;
    private final SonePlugin sonePlugin;
    private final EventBus eventBus;

    @Override
    protected void configure() {
        DebugLoaders debugLoaders;
        Object it;
        boolean bl;
        boolean bl2;
        Object object;
        Configuration configuration;
        File sonePropertiesFile = new File("sone.properties");
        boolean firstStart = !sonePropertiesFile.exists();
        boolean newConfig = false;
        try {
            configuration = new Configuration(new MapConfigurationBackend(sonePropertiesFile, false));
        }
        catch (ConfigurationException ce) {
            sonePropertiesFile.delete();
            newConfig = true;
            configuration = new Configuration(new MapConfigurationBackend(sonePropertiesFile, true));
        }
        Configuration configuration2 = configuration;
        Context context = new Context("Sone");
        String string = configuration2.getStringValue("Developer.LoadFromFilesystem").getValue(null);
        if (string != null) {
            object = string;
            bl2 = false;
            bl = false;
            it = object;
            boolean bl3 = false;
            String string2 = configuration2.getStringValue("Developer.FilesystemPath").getValue(null);
            if (string2 != null) {
                String string3 = string2;
                boolean bl4 = false;
                boolean bl5 = false;
                String it2 = string3;
                boolean bl6 = false;
                debugLoaders = new DebugLoaders(it2);
            } else {
                debugLoaders = null;
            }
        } else {
            debugLoaders = null;
        }
        DebugLoaders loaders = debugLoaders;
        this.bind(Configuration.class).toInstance(configuration2);
        this.bind(EventBus.class).toInstance(this.eventBus);
        this.bind(Boolean.TYPE).annotatedWith(Names.named("FirstStart")).toInstance(firstStart);
        this.bind(Boolean.TYPE).annotatedWith(Names.named("NewConfig")).toInstance(newConfig);
        this.bind(Context.class).toInstance(context);
        this.bind(new TypeLiteral<Optional<Context>>(){}).toInstance(Optional.of(context));
        this.bind(SonePlugin.class).toInstance(this.sonePlugin);
        AnnotatedBindingBuilder<Version> annotatedBindingBuilder = this.bind(Version.class);
        String string4 = this.sonePlugin.getVersion();
        Intrinsics.checkExpressionValueIsNotNull(string4, "sonePlugin.version");
        annotatedBindingBuilder.toInstance(SoneModuleKt.access$parseVersion(StringsKt.drop(string4, 1)));
        AnnotatedBindingBuilder<PluginVersion> annotatedBindingBuilder2 = this.bind(PluginVersion.class);
        String string5 = this.sonePlugin.getVersion();
        Intrinsics.checkExpressionValueIsNotNull(string5, "sonePlugin.version");
        annotatedBindingBuilder2.toInstance(new PluginVersion(string5));
        this.bind(PluginYear.class).toInstance(new PluginYear(this.sonePlugin.getYear()));
        AnnotatedBindingBuilder<PluginHomepage> annotatedBindingBuilder3 = this.bind(PluginHomepage.class);
        String string6 = this.sonePlugin.getHomepage();
        Intrinsics.checkExpressionValueIsNotNull(string6, "sonePlugin.homepage");
        annotatedBindingBuilder3.toInstance(new PluginHomepage(string6));
        this.bind(Database.class).to(MemoryDatabase.class).in(Singleton.class);
        AnnotatedBindingBuilder<Translation> annotatedBindingBuilder4 = this.bind(Translation.class);
        PluginL10n pluginL10n = this.sonePlugin.l10n();
        Intrinsics.checkExpressionValueIsNotNull(pluginL10n, "sonePlugin.l10n()");
        BaseL10n baseL10n = pluginL10n.getBase();
        Intrinsics.checkExpressionValueIsNotNull(baseL10n, "sonePlugin.l10n().base");
        annotatedBindingBuilder4.toInstance(new BaseL10nTranslation(baseL10n));
        DebugLoaders debugLoaders2 = loaders;
        if (debugLoaders2 != null) {
            object = debugLoaders2;
            bl2 = false;
            bl = false;
            it = object;
            boolean bl7 = false;
            this.bind(Loaders.class).toInstance((Loaders)it);
        }
        this.bind(MetricRegistry.class).in(Singleton.class);
        this.bind(WebOfTrustConnector.class).to(PluginWebOfTrustConnector.class).in(Singleton.class);
        this.bind(TickerShutdown.class).in(Singleton.class);
        this.bind(SoneUriCreator.class).in(Singleton.class);
        this.bind(SessionProvider.class).to(FreenetSessionProvider.class).in(Singleton.class);
        this.bindListener(Matchers.any(), new TypeListener(this){
            final /* synthetic */ SoneModule this$0;

            public <I> void hear(@NotNull TypeLiteral<I> typeLiteral, @NotNull TypeEncounter<I> typeEncounter) {
                Intrinsics.checkParameterIsNotNull(typeLiteral, "typeLiteral");
                Intrinsics.checkParameterIsNotNull(typeEncounter, "typeEncounter");
                typeEncounter.register(new InjectionListener<I>(this){
                    final /* synthetic */ configure.3 this$0;

                    public final void afterInjection(I injectee) {
                        SoneModule.access$getLogger$p(this.this$0.this$0).fine(new Supplier<String>(injectee){
                            final /* synthetic */ Object $injectee;

                            @NotNull
                            public final String get() {
                                return "Injecting " + this.$injectee + "...";
                            }
                            {
                                this.$injectee = object;
                            }
                        });
                        SoneModule.access$getEventBus$p(this.this$0.this$0).register(injectee);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.this$0 = $outer;
            }
        });
    }

    @Provides
    @Singleton
    @Named(value="notification")
    @NotNull
    public final ScheduledExecutorService getNotificationTicker() {
        ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
        Intrinsics.checkExpressionValueIsNotNull(scheduledExecutorService, "newSingleThreadScheduledExecutor()");
        return scheduledExecutorService;
    }

    public SoneModule(@NotNull SonePlugin sonePlugin, @NotNull EventBus eventBus) {
        Intrinsics.checkParameterIsNotNull(sonePlugin, "sonePlugin");
        Intrinsics.checkParameterIsNotNull(eventBus, "eventBus");
        this.sonePlugin = sonePlugin;
        this.eventBus = eventBus;
        Logger logger = Logging.getLogger(this.getClass());
        Intrinsics.checkExpressionValueIsNotNull(logger, "Logging.getLogger(javaClass)");
        this.logger = logger;
    }

    public static final /* synthetic */ Logger access$getLogger$p(SoneModule $this) {
        return $this.logger;
    }

    public static final /* synthetic */ EventBus access$getEventBus$p(SoneModule $this) {
        return $this.eventBus;
    }
}

