/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.sone.freenet;

import com.google.common.base.Preconditions;
import freenet.support.SimpleFieldSet;

public class SimpleFieldSetBuilder {
    private final SimpleFieldSet simpleFieldSet;

    public SimpleFieldSetBuilder() {
        this(new SimpleFieldSet(true));
    }

    public SimpleFieldSetBuilder(SimpleFieldSet simpleFieldSet) {
        this.simpleFieldSet = Preconditions.checkNotNull(simpleFieldSet, "simpleFieldSet must not be null");
    }

    public SimpleFieldSet get() {
        return this.simpleFieldSet;
    }

    public SimpleFieldSetBuilder put(SimpleFieldSet simpleFieldSet) {
        this.simpleFieldSet.putAllOverwrite(simpleFieldSet);
        return this;
    }

    public SimpleFieldSetBuilder put(String key, String value) {
        this.simpleFieldSet.putOverwrite(key, value);
        return this;
    }

    public SimpleFieldSetBuilder put(String key, int value) {
        this.simpleFieldSet.put(key, value);
        return this;
    }

    public SimpleFieldSetBuilder put(String key, long value) {
        this.simpleFieldSet.put(key, value);
        return this;
    }
}

