/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.sone.database.memory;

import com.google.common.base.Optional;
import net.pterodactylus.sone.data.Post;
import net.pterodactylus.sone.data.PostReply;
import net.pterodactylus.sone.data.Sone;
import net.pterodactylus.sone.database.SoneProvider;
import net.pterodactylus.sone.database.memory.MemoryDatabase;

class MemoryPostReply
implements PostReply {
    private final MemoryDatabase database;
    private final SoneProvider soneProvider;
    private final String id;
    private final String soneId;
    private final long time;
    private final String text;
    private final String postId;

    public MemoryPostReply(MemoryDatabase database, SoneProvider soneProvider, String id, String soneId2, long time, String text, String postId) {
        this.database = database;
        this.soneProvider = soneProvider;
        this.id = id;
        this.soneId = soneId2;
        this.time = time;
        this.text = text;
        this.postId = postId;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Sone getSone() {
        return this.soneProvider.getSone(this.soneId);
    }

    @Override
    public long getTime() {
        return this.time;
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public boolean isKnown() {
        return this.database.isPostReplyKnown(this);
    }

    @Override
    public String getPostId() {
        return this.postId;
    }

    @Override
    public Optional<Post> getPost() {
        return Optional.fromNullable(this.database.getPost(this.postId));
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof MemoryPostReply)) {
            return false;
        }
        MemoryPostReply memoryPostReply = (MemoryPostReply)object;
        return memoryPostReply.id.equals(this.id);
    }

    public String toString() {
        return "MemoryPostReply{database=" + this.database + ", soneProvider=" + this.soneProvider + ", id='" + this.id + '\'' + ", soneId='" + this.soneId + '\'' + ", time=" + this.time + ", text='" + this.text + '\'' + ", postId='" + this.postId + '\'' + '}';
    }
}

