/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.sone.database.memory;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.pterodactylus.sone.database.memory.ConfigurationLoader;

class MemoryFriendDatabase {
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final ConfigurationLoader configurationLoader;
    private final Multimap<String, String> soneFriends = HashMultimap.create();

    MemoryFriendDatabase(ConfigurationLoader configurationLoader) {
        this.configurationLoader = configurationLoader;
    }

    Collection<String> getFriends(String localSoneId) {
        this.loadFriends(localSoneId);
        this.lock.readLock().lock();
        try {
            Collection<String> collection = this.soneFriends.get(localSoneId);
            return collection;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isFriend(String localSoneId, String friendSoneId) {
        this.loadFriends(localSoneId);
        this.lock.readLock().lock();
        try {
            boolean bl = this.soneFriends.containsEntry(localSoneId, friendSoneId);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    void addFriend(String localSoneId, String friendSoneId) {
        this.loadFriends(localSoneId);
        this.lock.writeLock().lock();
        try {
            if (this.soneFriends.put(localSoneId, friendSoneId)) {
                this.configurationLoader.saveFriends(localSoneId, this.soneFriends.get(localSoneId));
                if (this.configurationLoader.getSoneFollowingTime(friendSoneId) == null) {
                    this.configurationLoader.setSoneFollowingTime(friendSoneId, System.currentTimeMillis());
                }
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeFriend(String localSoneId, String friendSoneId) {
        this.loadFriends(localSoneId);
        this.lock.writeLock().lock();
        try {
            if (this.soneFriends.remove(localSoneId, friendSoneId)) {
                this.configurationLoader.saveFriends(localSoneId, this.soneFriends.get(localSoneId));
                boolean unfollowedSoneStillFollowed = false;
                for (String soneId2 : this.soneFriends.keys()) {
                    unfollowedSoneStillFollowed |= this.getFriends(soneId2).contains(friendSoneId);
                }
                if (!unfollowedSoneStillFollowed) {
                    this.configurationLoader.removeSoneFollowingTime(friendSoneId);
                }
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Nullable
    Long getFollowingTime(@Nonnull String soneId2) {
        return this.configurationLoader.getSoneFollowingTime(soneId2);
    }

    private void loadFriends(String localSoneId) {
        this.lock.writeLock().lock();
        try {
            if (this.soneFriends.containsKey(localSoneId)) {
                return;
            }
            this.soneFriends.putAll(localSoneId, this.configurationLoader.loadFriends(localSoneId));
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }
}

