/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.sone.database.memory;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.pterodactylus.util.config.Configuration;
import net.pterodactylus.util.config.ConfigurationException;

public class ConfigurationLoader {
    private static final Logger logger = Logger.getLogger(ConfigurationLoader.class.getName());
    private final Configuration configuration;

    public ConfigurationLoader(Configuration configuration) {
        this.configuration = configuration;
    }

    public synchronized Set<String> loadFriends(String localSoneId) {
        return this.loadIds("Sone/" + localSoneId + "/Friends");
    }

    public void saveFriends(String soneId2, Collection<String> friends) {
        this.saveIds("Sone/" + soneId2 + "/Friends", friends);
    }

    public synchronized Set<String> loadKnownPosts() {
        return this.loadIds("KnownPosts");
    }

    public synchronized Set<String> loadKnownPostReplies() {
        return this.loadIds("KnownReplies");
    }

    public synchronized Set<String> loadBookmarkedPosts() {
        return this.loadIds("Bookmarks/Post");
    }

    @Nullable
    public synchronized Long getSoneFollowingTime(@Nonnull String soneId2) {
        return this.loadSoneFollowingTimes().get(soneId2);
    }

    public synchronized void removeSoneFollowingTime(@Nonnull String soneId2) {
        Map<String, Long> soneFollowingTimes = this.loadSoneFollowingTimes();
        soneFollowingTimes.remove(soneId2);
        this.storeSoneFollowingTimes(soneFollowingTimes);
    }

    public synchronized void setSoneFollowingTime(@Nonnull String soneId2, long time) {
        Map<String, Long> soneFollowingTimes = this.loadSoneFollowingTimes();
        soneFollowingTimes.put(soneId2, time);
        this.storeSoneFollowingTimes(soneFollowingTimes);
    }

    private synchronized Map<String, Long> loadSoneFollowingTimes() {
        String soneId2;
        HashMap<String, Long> soneFollowingTimes = new HashMap<String, Long>();
        int soneCounter = 0;
        while ((soneId2 = (String)this.configuration.getStringValue("SoneFollowingTimes/" + soneCounter + "/Sone").getValue(null)) != null) {
            soneFollowingTimes.put(soneId2, this.configuration.getLongValue("SoneFollowingTimes/" + soneCounter++ + "/Time").getValue(null));
        }
        return soneFollowingTimes;
    }

    private synchronized void storeSoneFollowingTimes(Map<String, Long> soneFollowingTimes) {
        int soneCounter = 0;
        try {
            for (Map.Entry<String, Long> soneFollowingTime : soneFollowingTimes.entrySet()) {
                this.configuration.getStringValue("SoneFollowingTimes/" + soneCounter + "/Sone").setValue(soneFollowingTime.getKey());
                this.configuration.getLongValue("SoneFollowingTimes/" + soneCounter + "/Time").setValue(soneFollowingTime.getValue());
                ++soneCounter;
            }
            this.configuration.getStringValue("SoneFollowingTimes/" + soneCounter + "/Sone").setValue(null);
        }
        catch (ConfigurationException ce1) {
            logger.log(Level.WARNING, "Could not save Sone following times!", ce1);
        }
    }

    private Set<String> loadIds(String prefix) {
        String id;
        HashSet<String> ids = new HashSet<String>();
        int idCounter = 0;
        while ((id = (String)this.configuration.getStringValue(prefix + "/" + idCounter++ + "/ID").getValue(null)) != null) {
            ids.add(id);
        }
        return ids;
    }

    public synchronized void saveBookmarkedPosts(Set<String> bookmarkedPosts) {
        this.saveIds("Bookmarks/Post", bookmarkedPosts);
    }

    private void saveIds(String prefix, Collection<String> ids) {
        try {
            int idCounter = 0;
            for (String id : ids) {
                this.configuration.getStringValue(prefix + "/" + idCounter++ + "/ID").setValue(id);
            }
            this.configuration.getStringValue(prefix + "/" + idCounter + "/ID").setValue(null);
        }
        catch (ConfigurationException ce1) {
            logger.log(Level.WARNING, "Could not save bookmarked posts!", ce1);
        }
    }
}

