/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.sone.data.impl;

import com.google.common.base.Preconditions;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import freenet.keys.FreenetURI;
import java.net.MalformedURLException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.pterodactylus.sone.data.Album;
import net.pterodactylus.sone.data.AlbumKt;
import net.pterodactylus.sone.data.Client;
import net.pterodactylus.sone.data.Post;
import net.pterodactylus.sone.data.PostKt;
import net.pterodactylus.sone.data.PostReply;
import net.pterodactylus.sone.data.Profile;
import net.pterodactylus.sone.data.ReplyKt;
import net.pterodactylus.sone.data.Sone;
import net.pterodactylus.sone.data.SoneKt;
import net.pterodactylus.sone.data.SoneOptions;
import net.pterodactylus.sone.data.impl.AlbumImpl;
import net.pterodactylus.sone.database.Database;
import net.pterodactylus.sone.freenet.wot.Identity;

public class SoneImpl
implements Sone {
    private static final Logger logger = Logger.getLogger(SoneImpl.class.getName());
    private final Database database;
    private final String id;
    private final boolean local;
    private final Identity identity;
    private volatile long latestEdition;
    private volatile long time;
    private volatile Sone.SoneStatus status = Sone.SoneStatus.unknown;
    private volatile Profile profile = new Profile(this);
    private volatile Client client;
    private volatile boolean known;
    private final Set<Post> posts = new CopyOnWriteArraySet<Post>();
    private final Set<PostReply> replies = new CopyOnWriteArraySet<PostReply>();
    private final Set<String> likedPostIds = new CopyOnWriteArraySet<String>();
    private final Set<String> likedReplyIds = new CopyOnWriteArraySet<String>();
    private final Album rootAlbum = new AlbumImpl(this);
    private SoneOptions options = new SoneOptions.DefaultSoneOptions();

    public SoneImpl(Database database, Identity identity, boolean local) {
        this.database = database;
        this.id = identity.getId();
        this.identity = identity;
        this.local = local;
    }

    @Override
    @Nonnull
    public String getId() {
        return this.id;
    }

    @Override
    @Nonnull
    public Identity getIdentity() {
        return this.identity;
    }

    @Override
    @Nonnull
    public String getName() {
        return this.identity != null ? this.identity.getNickname() : null;
    }

    @Override
    public boolean isLocal() {
        return this.local;
    }

    @Override
    @Nonnull
    public FreenetURI getRequestUri() {
        try {
            return new FreenetURI(this.getIdentity().getRequestUri()).setKeyType("USK").setDocName("Sone").setMetaString(new String[0]).setSuggestedEdition(this.latestEdition);
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException(String.format("Identity %s's request URI is incorrect.", this.getIdentity()), e);
        }
    }

    @Override
    public long getLatestEdition() {
        return this.latestEdition;
    }

    @Override
    public void setLatestEdition(long latestEdition) {
        if (latestEdition <= this.latestEdition) {
            logger.log(Level.FINE, String.format("New latest edition %d is not greater than current latest edition %d!", latestEdition, this.latestEdition));
            return;
        }
        this.latestEdition = latestEdition;
    }

    @Override
    public long getTime() {
        return this.time;
    }

    @Override
    @Nonnull
    public Sone setTime(long time) {
        this.time = time;
        return this;
    }

    @Override
    @Nonnull
    public Sone.SoneStatus getStatus() {
        return this.status;
    }

    @Override
    @Nonnull
    public Sone setStatus(@Nonnull Sone.SoneStatus status) {
        this.status = Preconditions.checkNotNull(status, "status must not be null");
        return this;
    }

    @Override
    @Nonnull
    public Profile getProfile() {
        return new Profile(this.profile);
    }

    @Override
    public void setProfile(@Nonnull Profile profile) {
        this.profile = new Profile(profile);
    }

    @Override
    @Nullable
    public Client getClient() {
        return this.client;
    }

    @Override
    @Nonnull
    public Sone setClient(@Nullable Client client) {
        this.client = client;
        return this;
    }

    @Override
    public boolean isKnown() {
        return this.known;
    }

    @Override
    @Nonnull
    public Sone setKnown(boolean known) {
        this.known = known;
        return this;
    }

    @Override
    @Nonnull
    public Collection<String> getFriends() {
        return this.database.getFriends(this);
    }

    @Override
    public boolean hasFriend(@Nonnull String friendSoneId) {
        return this.database.isFriend(this, friendSoneId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public List<Post> getPosts() {
        ArrayList<Post> sortedPosts;
        SoneImpl soneImpl = this;
        synchronized (soneImpl) {
            sortedPosts = new ArrayList<Post>(this.posts);
        }
        sortedPosts.sort(PostKt.newestPostFirst());
        return sortedPosts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public Sone setPosts(@Nonnull Collection<Post> posts) {
        SoneImpl soneImpl = this;
        synchronized (soneImpl) {
            this.posts.clear();
            this.posts.addAll(posts);
        }
        return this;
    }

    @Override
    public void addPost(@Nonnull Post post) {
        if (post.getSone().equals(this) && this.posts.add(post)) {
            logger.log(Level.FINEST, String.format("Adding %s to \u201c%s\u201d.", post, this.getName()));
        }
    }

    @Override
    public void removePost(@Nonnull Post post) {
        if (post.getSone().equals(this)) {
            this.posts.remove(post);
        }
    }

    @Override
    @Nonnull
    public Set<PostReply> getReplies() {
        return Collections.unmodifiableSet(this.replies);
    }

    @Override
    @Nonnull
    public Sone setReplies(@Nonnull Collection<PostReply> replies) {
        this.replies.clear();
        this.replies.addAll(replies);
        return this;
    }

    @Override
    public void addReply(@Nonnull PostReply reply) {
        if (reply.getSone().equals(this)) {
            this.replies.add(reply);
        }
    }

    @Override
    public void removeReply(@Nonnull PostReply reply) {
        if (reply.getSone().equals(this)) {
            this.replies.remove(reply);
        }
    }

    @Override
    @Nonnull
    public Set<String> getLikedPostIds() {
        return Collections.unmodifiableSet(this.likedPostIds);
    }

    @Override
    @Nonnull
    public Sone setLikePostIds(@Nonnull Set<String> likedPostIds) {
        this.likedPostIds.clear();
        this.likedPostIds.addAll(likedPostIds);
        return this;
    }

    @Override
    public boolean isLikedPostId(@Nonnull String postId) {
        return this.likedPostIds.contains(postId);
    }

    @Override
    @Nonnull
    public Sone addLikedPostId(@Nonnull String postId) {
        this.likedPostIds.add(postId);
        return this;
    }

    @Override
    public void removeLikedPostId(@Nonnull String postId) {
        this.likedPostIds.remove(postId);
    }

    @Override
    @Nonnull
    public Set<String> getLikedReplyIds() {
        return Collections.unmodifiableSet(this.likedReplyIds);
    }

    @Override
    @Nonnull
    public Sone setLikeReplyIds(@Nonnull Set<String> likedReplyIds) {
        this.likedReplyIds.clear();
        this.likedReplyIds.addAll(likedReplyIds);
        return this;
    }

    @Override
    public boolean isLikedReplyId(@Nonnull String replyId) {
        return this.likedReplyIds.contains(replyId);
    }

    @Override
    @Nonnull
    public Sone addLikedReplyId(@Nonnull String replyId) {
        this.likedReplyIds.add(replyId);
        return this;
    }

    @Override
    public void removeLikedReplyId(@Nonnull String replyId) {
        this.likedReplyIds.remove(replyId);
    }

    @Override
    @Nonnull
    public Album getRootAlbum() {
        return this.rootAlbum;
    }

    @Override
    @Nonnull
    public SoneOptions getOptions() {
        return this.options;
    }

    @Override
    public void setOptions(@Nonnull SoneOptions options) {
        this.options = options;
    }

    @Override
    public synchronized String getFingerprint() {
        Hasher hash = Hashing.sha256().newHasher();
        hash.putString(this.profile.getFingerprint(), StandardCharsets.UTF_8);
        hash.putString("Posts(", StandardCharsets.UTF_8);
        for (Post post : this.getPosts()) {
            hash.putString("Post(", StandardCharsets.UTF_8).putString(post.getId(), StandardCharsets.UTF_8).putString(")", StandardCharsets.UTF_8);
        }
        hash.putString(")", StandardCharsets.UTF_8);
        ArrayList<PostReply> replies = new ArrayList<PostReply>(this.getReplies());
        replies.sort(ReplyKt.newestReplyFirst().reversed());
        hash.putString("Replies(", StandardCharsets.UTF_8);
        for (PostReply postReply : replies) {
            hash.putString("Reply(", StandardCharsets.UTF_8).putString(postReply.getId(), StandardCharsets.UTF_8).putString(")", StandardCharsets.UTF_8);
        }
        hash.putString(")", StandardCharsets.UTF_8);
        ArrayList<String> arrayList = new ArrayList<String>(this.getLikedPostIds());
        Collections.sort(arrayList);
        hash.putString("LikedPosts(", StandardCharsets.UTF_8);
        for (String likedPostId : arrayList) {
            hash.putString("Post(", StandardCharsets.UTF_8).putString(likedPostId, StandardCharsets.UTF_8).putString(")", StandardCharsets.UTF_8);
        }
        hash.putString(")", StandardCharsets.UTF_8);
        ArrayList<String> arrayList2 = new ArrayList<String>(this.getLikedReplyIds());
        Collections.sort(arrayList2);
        hash.putString("LikedReplies(", StandardCharsets.UTF_8);
        for (String likedReplyId : arrayList2) {
            hash.putString("Reply(", StandardCharsets.UTF_8).putString(likedReplyId, StandardCharsets.UTF_8).putString(")", StandardCharsets.UTF_8);
        }
        hash.putString(")", StandardCharsets.UTF_8);
        hash.putString("Albums(", StandardCharsets.UTF_8);
        for (Album album : this.rootAlbum.getAlbums()) {
            if (!AlbumKt.notEmpty().invoke(album).booleanValue()) continue;
            hash.putString(album.getFingerprint(), StandardCharsets.UTF_8);
        }
        hash.putString(")", StandardCharsets.UTF_8);
        return hash.hash().toString();
    }

    @Override
    public int compareTo(Sone sone) {
        return SoneKt.niceNameComparator().compare(this, sone);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof Sone)) {
            return false;
        }
        return ((Sone)object).getId().equals(this.id);
    }

    public String toString() {
        return this.getClass().getName() + "[identity=" + this.identity + ",posts(" + this.posts.size() + "),replies(" + this.replies.size() + "),albums(" + this.getRootAlbum().getAlbums().size() + ")]";
    }
}

