/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.sone.data;

import com.google.common.base.Preconditions;
import java.util.UUID;

public class TemporaryImage {
    private final String id;
    private String mimeType;
    private byte[] imageData;

    public TemporaryImage() {
        this(UUID.randomUUID().toString());
    }

    public TemporaryImage(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public TemporaryImage setMimeType(String mimeType) {
        Preconditions.checkNotNull(mimeType, "mimeType must not be null");
        Preconditions.checkState(this.mimeType == null, "mime type must not already be set");
        this.mimeType = mimeType;
        return this;
    }

    public byte[] getImageData() {
        return this.imageData;
    }

    public TemporaryImage setImageData(byte[] imageData) {
        Preconditions.checkNotNull(imageData, "imageData must not be null");
        Preconditions.checkState(this.imageData == null, "image data must not already be set");
        this.imageData = imageData;
        return this;
    }
}

