/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.sone.data;

import com.google.common.base.Optional;
import net.pterodactylus.sone.data.Identified;
import net.pterodactylus.sone.data.Sone;

public interface Post
extends Identified {
    @Override
    public String getId();

    public boolean isLoaded();

    public Sone getSone();

    public Optional<String> getRecipientId();

    public Optional<Sone> getRecipient();

    public long getTime();

    public String getText();

    public boolean isKnown();

    public Post setKnown(boolean var1);

    public static class EmptyPost
    implements Post {
        private final String id;

        public EmptyPost(String id) {
            this.id = id;
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public boolean isLoaded() {
            return false;
        }

        @Override
        public Sone getSone() {
            return null;
        }

        @Override
        public Optional<String> getRecipientId() {
            return Optional.absent();
        }

        @Override
        public Optional<Sone> getRecipient() {
            return Optional.absent();
        }

        @Override
        public long getTime() {
            return 0L;
        }

        @Override
        public String getText() {
            return null;
        }

        @Override
        public boolean isKnown() {
            return false;
        }

        @Override
        public Post setKnown(boolean known) {
            return this;
        }
    }
}

