/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.sone.core;

import com.codahale.metrics.ExponentiallyDecayingReservoir;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Ordering;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import freenet.keys.FreenetURI;
import freenet.support.api.Bucket;
import freenet.support.api.ManifestElement;
import freenet.support.api.RandomAccessBucket;
import freenet.support.io.ArrayBucket;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import net.pterodactylus.sone.core.Core;
import net.pterodactylus.sone.core.FreenetInterface;
import net.pterodactylus.sone.core.SoneException;
import net.pterodactylus.sone.core.SoneModificationDetector;
import net.pterodactylus.sone.core.SoneUriCreator;
import net.pterodactylus.sone.core.event.InsertionDelayChangedEvent;
import net.pterodactylus.sone.core.event.SoneInsertAbortedEvent;
import net.pterodactylus.sone.core.event.SoneInsertedEvent;
import net.pterodactylus.sone.core.event.SoneInsertingEvent;
import net.pterodactylus.sone.data.AlbumKt;
import net.pterodactylus.sone.data.PostKt;
import net.pterodactylus.sone.data.ReplyKt;
import net.pterodactylus.sone.data.Sone;
import net.pterodactylus.sone.data.SoneKt;
import net.pterodactylus.sone.main.SonePlugin;
import net.pterodactylus.util.service.AbstractService;
import net.pterodactylus.util.template.HtmlFilter;
import net.pterodactylus.util.template.ReflectionAccessor;
import net.pterodactylus.util.template.Template;
import net.pterodactylus.util.template.TemplateContext;
import net.pterodactylus.util.template.TemplateContextFactory;
import net.pterodactylus.util.template.TemplateException;
import net.pterodactylus.util.template.TemplateParser;
import net.pterodactylus.util.template.XmlFilter;

public class SoneInserter
extends AbstractService {
    private static final Logger logger = Logger.getLogger(SoneInserter.class.getName());
    private static final AtomicInteger insertionDelay = new AtomicInteger(60);
    private static final TemplateContextFactory templateContextFactory = new TemplateContextFactory();
    private static final Charset utf8Charset;
    private final Core core;
    private final EventBus eventBus;
    private final FreenetInterface freenetInterface;
    private final SoneModificationDetector soneModificationDetector;
    private final SoneUriCreator soneUriCreator;
    private final long delay;
    private final String soneId;
    private final Histogram soneInsertDurationHistogram;
    private final Meter soneInsertErrorMeter;

    public SoneInserter(final Core core, EventBus eventBus, FreenetInterface freenetInterface, MetricRegistry metricRegistry, SoneUriCreator soneUriCreator, final String soneId2) {
        this(core, eventBus, freenetInterface, metricRegistry, soneUriCreator, soneId2, new SoneModificationDetector(new SoneModificationDetector.LockableFingerprintProvider(){

            @Override
            public boolean isLocked() {
                Sone sone = core.getSone(soneId2);
                if (sone == null) {
                    return false;
                }
                return core.isLocked(sone);
            }

            @Override
            public String getFingerprint() {
                Sone sone = core.getSone(soneId2);
                if (sone == null) {
                    return null;
                }
                return sone.getFingerprint();
            }
        }, insertionDelay), 1000L);
    }

    @VisibleForTesting
    SoneInserter(Core core, EventBus eventBus, FreenetInterface freenetInterface, MetricRegistry metricRegistry, SoneUriCreator soneUriCreator, String soneId2, SoneModificationDetector soneModificationDetector, long delay) {
        super("Sone Inserter for \u201c" + soneId2 + "\u201d", false);
        this.core = core;
        this.eventBus = eventBus;
        this.freenetInterface = freenetInterface;
        this.soneInsertDurationHistogram = metricRegistry.histogram("sone.insert.duration", () -> new Histogram(new ExponentiallyDecayingReservoir(3000, 0.0)));
        this.soneInsertErrorMeter = metricRegistry.meter("sone.insert.errors");
        this.soneUriCreator = soneUriCreator;
        this.soneId = soneId2;
        this.soneModificationDetector = soneModificationDetector;
        this.delay = delay;
    }

    @VisibleForTesting
    static AtomicInteger getInsertionDelay() {
        return insertionDelay;
    }

    private static void setInsertionDelay(int insertionDelay) {
        SoneInserter.insertionDelay.set(insertionDelay);
    }

    public String getLastInsertFingerprint() {
        return this.soneModificationDetector.getLastInsertFingerprint();
    }

    public void setLastInsertFingerprint(String lastInsertFingerprint) {
        this.soneModificationDetector.setFingerprint(lastInsertFingerprint);
    }

    public boolean isModified() {
        return this.soneModificationDetector.isModified();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void serviceRun() {
        while (!this.shouldStop()) {
            try {
                this.sleep(this.delay);
                if (!this.soneModificationDetector.isEligibleForInsert()) continue;
                Sone sone = this.core.getSone(this.soneId);
                if (sone == null) {
                    logger.log(Level.WARNING, String.format("Sone %s has disappeared, exiting inserter.", this.soneId));
                    return;
                }
                InsertInformation insertInformation = new InsertInformation(sone);
                logger.log(Level.INFO, String.format("Inserting Sone \u201c%s\u201d\u2026", sone.getName()));
                boolean success = false;
                try {
                    sone.setStatus(Sone.SoneStatus.inserting);
                    long insertTime = System.currentTimeMillis();
                    this.eventBus.post(new SoneInsertingEvent(sone));
                    Stopwatch stopwatch = Stopwatch.createStarted();
                    FreenetURI finalUri = this.freenetInterface.insertDirectory(this.soneUriCreator.getInsertUri(sone), insertInformation.generateManifestEntries(), "index.html");
                    stopwatch.stop();
                    this.soneInsertDurationHistogram.update(stopwatch.elapsed(TimeUnit.MICROSECONDS));
                    this.eventBus.post(new SoneInsertedEvent(sone, stopwatch.elapsed(TimeUnit.MILLISECONDS), insertInformation.getFingerprint()));
                    if (this.shouldStop()) break;
                    sone.setTime(insertTime);
                    sone.setLatestEdition(finalUri.getEdition());
                    this.core.touchConfiguration();
                    success = true;
                    logger.log(Level.INFO, String.format("Inserted Sone \u201c%s\u201d at %s.", sone.getName(), finalUri));
                }
                catch (SoneException se1) {
                    this.soneInsertErrorMeter.mark();
                    this.eventBus.post(new SoneInsertAbortedEvent(sone, se1));
                    logger.log(Level.WARNING, String.format("Could not insert Sone \u201c%s\u201d!", sone.getName()), se1);
                }
                finally {
                    insertInformation.close();
                    sone.setStatus(Sone.SoneStatus.idle);
                }
                if (!success) continue;
                Sone sone2 = sone;
                synchronized (sone2) {
                    if (insertInformation.getFingerprint().equals(sone.getFingerprint())) {
                        logger.log(Level.FINE, String.format("Sone \u201c%s\u201d was not modified further, resetting counter\u2026", sone));
                        this.soneModificationDetector.setFingerprint(insertInformation.getFingerprint());
                        this.core.touchConfiguration();
                    }
                }
            }
            catch (Throwable t1) {
                logger.log(Level.SEVERE, "SoneInserter threw an Exception!", t1);
            }
        }
    }

    @Subscribe
    public void insertionDelayChanged(InsertionDelayChangedEvent insertionDelayChangedEvent) {
        SoneInserter.setInsertionDelay(insertionDelayChangedEvent.getInsertionDelay());
    }

    static {
        templateContextFactory.addAccessor(Object.class, new ReflectionAccessor());
        templateContextFactory.addFilter("xml", new XmlFilter());
        templateContextFactory.addFilter("html", new HtmlFilter());
        utf8Charset = Charset.forName("UTF-8");
    }

    @VisibleForTesting
    static class ManifestCreator
    implements Closeable {
        private final Core core;
        private final Map<String, Object> soneProperties;
        private final Set<Bucket> buckets = new HashSet<Bucket>();

        ManifestCreator(Core core, Map<String, Object> soneProperties) {
            this.core = core;
            this.soneProperties = soneProperties;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public ManifestElement createManifestElement(String name, String contentType, String templateName) {
            Template template;
            try (InputStream templateInputStream = this.getClass().getResourceAsStream(templateName);
                 InputStreamReader templateInputStreamReader = new InputStreamReader(templateInputStream, utf8Charset);){
                template = TemplateParser.parse(templateInputStreamReader);
            }
            catch (IOException | TemplateException e1) {
                logger.log(Level.SEVERE, String.format("Could not parse template \u201c%s\u201d!", templateName), e1);
                return null;
            }
            TemplateContext templateContext = templateContextFactory.createTemplateContext();
            templateContext.set("core", this.core);
            templateContext.set("currentSone", this.soneProperties);
            templateContext.set("currentEdition", this.core.getUpdateChecker().getLatestEdition());
            templateContext.set("version", SonePlugin.getPluginVersion());
            try (StringWriter writer = new StringWriter();){
                template.render(templateContext, writer);
                ArrayBucket bucket = new ArrayBucket(writer.toString().getBytes(Charsets.UTF_8));
                this.buckets.add((Bucket)bucket);
                ManifestElement manifestElement = new ManifestElement(name, (RandomAccessBucket)bucket, contentType, bucket.size());
                return manifestElement;
            }
            catch (IOException | TemplateException e1) {
                logger.log(Level.SEVERE, String.format("Could not render template \u201c%s\u201d!", templateName), e1);
                return null;
            }
        }

        @Override
        public void close() {
            for (Bucket bucket : this.buckets) {
                bucket.free();
            }
        }
    }

    @VisibleForTesting
    class InsertInformation
    implements Closeable {
        private final Map<String, Object> soneProperties = new HashMap<String, Object>();
        private final String fingerprint;
        private final ManifestCreator manifestCreator;

        public InsertInformation(Sone sone) {
            this.fingerprint = sone.getFingerprint();
            HashMap<String, Object> soneProperties = new HashMap<String, Object>();
            soneProperties.put("id", sone.getId());
            soneProperties.put("name", sone.getName());
            soneProperties.put("time", System.currentTimeMillis());
            soneProperties.put("profile", sone.getProfile());
            soneProperties.put("posts", Ordering.from(PostKt.newestPostFirst()).sortedCopy(sone.getPosts()));
            soneProperties.put("replies", Ordering.from(ReplyKt.newestReplyFirst()).sortedCopy(sone.getReplies()));
            soneProperties.put("likedPostIds", new HashSet<String>(sone.getLikedPostIds()));
            soneProperties.put("likedReplyIds", new HashSet<String>(sone.getLikedReplyIds()));
            soneProperties.put("albums", SoneKt.getAllAlbums(sone).stream().filter(AlbumKt.notEmpty()::invoke).collect(Collectors.toList()));
            this.manifestCreator = new ManifestCreator(SoneInserter.this.core, soneProperties);
        }

        @VisibleForTesting
        String getFingerprint() {
            return this.fingerprint;
        }

        public HashMap<String, Object> generateManifestEntries() {
            HashMap<String, Object> manifestEntries = new HashMap<String, Object>();
            manifestEntries.put("index.html", this.manifestCreator.createManifestElement("index.html", "text/html; charset=utf-8", "/templates/insert/index.html"));
            manifestEntries.put("sone.xml", this.manifestCreator.createManifestElement("sone.xml", "text/xml; charset=utf-8", "/templates/insert/sone.xml"));
            return manifestEntries;
        }

        @Override
        public void close() {
            this.manifestCreator.close();
        }
    }
}

