/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.sone.core;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import net.pterodactylus.sone.data.Post;
import net.pterodactylus.sone.data.PostReply;
import net.pterodactylus.sone.data.Sone;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00078F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u00078F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\nR\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\b0\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\nR\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\f0\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\n\u00a8\u0006\u0012"}, d2={"Lnet/pterodactylus/sone/core/SoneComparison;", "", "oldSone", "Lnet/pterodactylus/sone/data/Sone;", "newSone", "(Lnet/pterodactylus/sone/data/Sone;Lnet/pterodactylus/sone/data/Sone;)V", "newPostReplies", "", "Lnet/pterodactylus/sone/data/PostReply;", "getNewPostReplies", "()Ljava/util/Collection;", "newPosts", "Lnet/pterodactylus/sone/data/Post;", "getNewPosts", "removedPostReplies", "getRemovedPostReplies", "removedPosts", "getRemovedPosts", "Sone"})
public final class SoneComparison {
    private final Sone oldSone;
    private final Sone newSone;

    @NotNull
    public final Collection<Post> getNewPosts() {
        List<Post> list = this.newSone.getPosts();
        Intrinsics.checkExpressionValueIsNotNull(list, "newSone.posts");
        Iterable iterable = list;
        List<Post> list2 = this.oldSone.getPosts();
        Intrinsics.checkExpressionValueIsNotNull(list2, "oldSone.posts");
        return CollectionsKt.minus(iterable, (Iterable)list2);
    }

    @NotNull
    public final Collection<Post> getRemovedPosts() {
        List<Post> list = this.oldSone.getPosts();
        Intrinsics.checkExpressionValueIsNotNull(list, "oldSone.posts");
        Iterable iterable = list;
        List<Post> list2 = this.newSone.getPosts();
        Intrinsics.checkExpressionValueIsNotNull(list2, "newSone.posts");
        return CollectionsKt.minus(iterable, (Iterable)list2);
    }

    @NotNull
    public final Collection<PostReply> getNewPostReplies() {
        Set<PostReply> set = this.newSone.getReplies();
        Intrinsics.checkExpressionValueIsNotNull(set, "newSone.replies");
        Set<PostReply> set2 = this.oldSone.getReplies();
        Intrinsics.checkExpressionValueIsNotNull(set2, "oldSone.replies");
        return SetsKt.minus(set, (Iterable)set2);
    }

    @NotNull
    public final Collection<PostReply> getRemovedPostReplies() {
        Set<PostReply> set = this.oldSone.getReplies();
        Intrinsics.checkExpressionValueIsNotNull(set, "oldSone.replies");
        Set<PostReply> set2 = this.newSone.getReplies();
        Intrinsics.checkExpressionValueIsNotNull(set2, "newSone.replies");
        return SetsKt.minus(set, (Iterable)set2);
    }

    public SoneComparison(@NotNull Sone oldSone, @NotNull Sone newSone) {
        Intrinsics.checkParameterIsNotNull(oldSone, "oldSone");
        Intrinsics.checkParameterIsNotNull(newSone, "newSone");
        this.oldSone = oldSone;
        this.newSone = newSone;
    }
}

