/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.sone.core;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import net.pterodactylus.sone.core.FreenetInterface;
import net.pterodactylus.sone.core.SoneException;
import net.pterodactylus.sone.data.Image;
import net.pterodactylus.sone.data.TemporaryImage;

public class ImageInserter {
    private static final Logger logger = Logger.getLogger(ImageInserter.class.getName());
    private final FreenetInterface freenetInterface;
    private final Function<Image, FreenetInterface.InsertToken> insertTokenSupplier;
    private final Map<String, FreenetInterface.InsertToken> insertTokens = Collections.synchronizedMap(new HashMap());

    @Inject
    public ImageInserter(FreenetInterface freenetInterface, FreenetInterface.InsertTokenSupplier insertTokenSupplier) {
        this.freenetInterface = freenetInterface;
        this.insertTokenSupplier = insertTokenSupplier;
    }

    public void insertImage(TemporaryImage temporaryImage, Image image) {
        Preconditions.checkNotNull(temporaryImage, "temporaryImage must not be null");
        Preconditions.checkNotNull(image, "image must not be null");
        Preconditions.checkArgument(image.getId().equals(temporaryImage.getId()), "image IDs must match");
        try {
            FreenetInterface.InsertToken insertToken = this.insertTokenSupplier.apply(image);
            this.insertTokens.put(image.getId(), insertToken);
            this.freenetInterface.insertImage(temporaryImage, image, insertToken);
        }
        catch (SoneException se1) {
            logger.log(Level.WARNING, "Could not insert image!", se1);
        }
    }

    public void cancelImageInsert(Image image) {
        FreenetInterface.InsertToken insertToken = this.insertTokens.remove(image.getId());
        if (insertToken == null) {
            return;
        }
        insertToken.cancel();
    }
}

