/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.coroutines.internal;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.jvm.internal.CoroutineStackFrame;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.DebugKt;
import kotlinx.coroutines.InternalCoroutinesApi;
import kotlinx.coroutines.internal.ExceptionsConstuctorKt;
import kotlinx.coroutines.internal.NonRecoverableThrowable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000d\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0007\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0007\u001a9\u0010\u0004\u001a\u0002H\u0005\"\b\b\u0000\u0010\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u0002H\u00052\u0006\u0010\b\u001a\u0002H\u00052\u0010\u0010\t\u001a\f\u0012\b\u0012\u00060\u0001j\u0002`\u000b0\nH\u0002\u00a2\u0006\u0002\u0010\f\u001a\u001e\u0010\r\u001a\f\u0012\b\u0012\u00060\u0001j\u0002`\u000b0\n2\n\u0010\u000e\u001a\u00060\u000fj\u0002`\u0010H\u0002\u001a1\u0010\u0011\u001a\u00020\u00122\u0010\u0010\u0013\u001a\f\u0012\b\u0012\u00060\u0001j\u0002`\u000b0\u00142\u0010\u0010\b\u001a\f\u0012\b\u0012\u00060\u0001j\u0002`\u000b0\nH\u0002\u00a2\u0006\u0002\u0010\u0015\u001a\u0019\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0006H\u0080H\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0019\u001a+\u0010\u001a\u001a\u0002H\u0005\"\b\b\u0000\u0010\u0005*\u00020\u00062\u0006\u0010\u0018\u001a\u0002H\u00052\n\u0010\u000e\u001a\u00060\u000fj\u0002`\u0010H\u0002\u00a2\u0006\u0002\u0010\u001b\u001a\u001f\u0010\u001c\u001a\u0002H\u0005\"\b\b\u0000\u0010\u0005*\u00020\u00062\u0006\u0010\u0018\u001a\u0002H\u0005H\u0000\u00a2\u0006\u0002\u0010\u001d\u001a+\u0010\u001c\u001a\u0002H\u0005\"\b\b\u0000\u0010\u0005*\u00020\u00062\u0006\u0010\u0018\u001a\u0002H\u00052\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u001eH\u0000\u00a2\u0006\u0002\u0010\u001f\u001a\u001f\u0010 \u001a\u00020!\"\b\b\u0000\u0010\u0005*\u00020\u00062\u0006\u0010\u0018\u001a\u0002H\u0005H\u0002\u00a2\u0006\u0002\u0010\"\u001a\u001f\u0010#\u001a\u0002H\u0005\"\b\b\u0000\u0010\u0005*\u00020\u00062\u0006\u0010\u0018\u001a\u0002H\u0005H\u0000\u00a2\u0006\u0002\u0010\u001d\u001a1\u0010$\u001a\u0018\u0012\u0004\u0012\u0002H\u0005\u0012\u000e\u0012\f\u0012\b\u0012\u00060\u0001j\u0002`\u000b0\u00140%\"\b\b\u0000\u0010\u0005*\u00020\u0006*\u0002H\u0005H\u0002\u00a2\u0006\u0002\u0010&\u001a\u001c\u0010'\u001a\u00020!*\u00060\u0001j\u0002`\u000b2\n\u0010(\u001a\u00060\u0001j\u0002`\u000bH\u0002\u001a#\u0010)\u001a\u00020**\f\u0012\b\u0012\u00060\u0001j\u0002`\u000b0\u00142\u0006\u0010+\u001a\u00020\u0003H\u0002\u00a2\u0006\u0002\u0010,\u001a\u0010\u0010-\u001a\u00020!*\u00060\u0001j\u0002`\u000bH\u0000\u001a\u001b\u0010.\u001a\u0002H\u0005\"\b\b\u0000\u0010\u0005*\u00020\u0006*\u0002H\u0005H\u0002\u00a2\u0006\u0002\u0010\u001d*\f\b\u0000\u0010/\"\u00020\u000f2\u00020\u000f*\f\b\u0000\u00100\"\u00020\u00012\u00020\u0001\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u00061"}, d2={"artificialFrame", "Ljava/lang/StackTraceElement;", "message", "", "createFinalException", "E", "", "cause", "result", "resultStackTrace", "Ljava/util/ArrayDeque;", "Lkotlinx/coroutines/internal/StackTraceElement;", "(Ljava/lang/Throwable;Ljava/lang/Throwable;Ljava/util/ArrayDeque;)Ljava/lang/Throwable;", "createStackTrace", "continuation", "Lkotlin/coroutines/jvm/internal/CoroutineStackFrame;", "Lkotlinx/coroutines/internal/CoroutineStackFrame;", "mergeRecoveredTraces", "", "recoveredStacktrace", "", "([Ljava/lang/StackTraceElement;Ljava/util/ArrayDeque;)V", "recoverAndThrow", "", "exception", "(Ljava/lang/Throwable;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "recoverFromStackFrame", "(Ljava/lang/Throwable;Lkotlin/coroutines/jvm/internal/CoroutineStackFrame;)Ljava/lang/Throwable;", "recoverStackTrace", "(Ljava/lang/Throwable;)Ljava/lang/Throwable;", "Lkotlin/coroutines/Continuation;", "(Ljava/lang/Throwable;Lkotlin/coroutines/Continuation;)Ljava/lang/Throwable;", "recoveryDisabled", "", "(Ljava/lang/Throwable;)Z", "unwrap", "causeAndStacktrace", "Lkotlin/Pair;", "(Ljava/lang/Throwable;)Lkotlin/Pair;", "elementWiseEquals", "e", "frameIndex", "", "methodName", "([Ljava/lang/StackTraceElement;Ljava/lang/String;)I", "isArtificial", "sanitizeStackTrace", "CoroutineStackFrame", "StackTraceElement", "kotlinx-coroutines-core"})
public final class StackTraceRecoveryKt {
    @NotNull
    public static final <E extends Throwable> E recoverStackTrace(@NotNull E exception) {
        Intrinsics.checkParameterIsNotNull(exception, "exception");
        if (StackTraceRecoveryKt.recoveryDisabled(exception)) {
            return exception;
        }
        E e = ExceptionsConstuctorKt.tryCopyException(exception);
        if (e == null) {
            return exception;
        }
        E copy = e;
        return StackTraceRecoveryKt.sanitizeStackTrace(copy);
    }

    /*
     * WARNING - void declaration
     */
    private static final <E extends Throwable> E sanitizeStackTrace(@NotNull E $this$sanitizeStackTrace) {
        StackTraceElement[] stackTrace = $this$sanitizeStackTrace.getStackTrace();
        int size = stackTrace.length;
        Intrinsics.checkExpressionValueIsNotNull(stackTrace, "stackTrace");
        int lastIntrinsic = StackTraceRecoveryKt.frameIndex(stackTrace, "kotlinx.coroutines.internal.StackTraceRecoveryKt");
        int startIndex = lastIntrinsic + 1;
        int endIndex = StackTraceRecoveryKt.frameIndex(stackTrace, "kotlin.coroutines.jvm.internal.BaseContinuationImpl");
        int adjustment = endIndex == -1 ? 0 : size - endIndex;
        int n = size - lastIntrinsic - adjustment;
        StackTraceElement[] stackTraceElementArray = new StackTraceElement[n];
        for (int j = 0; j < n; ++j) {
            void it;
            StackTraceElement stackTraceElement;
            int n2 = j;
            int n3 = j;
            StackTraceElement[] stackTraceElementArray2 = stackTraceElementArray;
            boolean bl = false;
            stackTraceElementArray2[n3] = stackTraceElement = it == false ? StackTraceRecoveryKt.artificialFrame("Coroutine boundary") : stackTrace[startIndex + it - 1];
        }
        StackTraceElement[] trace = stackTraceElementArray;
        $this$sanitizeStackTrace.setStackTrace(trace);
        return $this$sanitizeStackTrace;
    }

    @NotNull
    public static final <E extends Throwable> E recoverStackTrace(@NotNull E exception, @NotNull Continuation<?> continuation2) {
        Intrinsics.checkParameterIsNotNull(exception, "exception");
        Intrinsics.checkParameterIsNotNull(continuation2, "continuation");
        if (StackTraceRecoveryKt.recoveryDisabled(exception) || !(continuation2 instanceof CoroutineStackFrame)) {
            return exception;
        }
        return StackTraceRecoveryKt.recoverFromStackFrame(exception, (CoroutineStackFrame)((Object)continuation2));
    }

    /*
     * WARNING - void declaration
     */
    private static final <E extends Throwable> E recoverFromStackFrame(E exception, CoroutineStackFrame continuation2) {
        void cause;
        Pair<E, StackTraceElement[]> pair = StackTraceRecoveryKt.causeAndStacktrace(exception);
        E e = pair.component1();
        StackTraceElement[] recoveredStacktrace = pair.component2();
        void v0 = ExceptionsConstuctorKt.tryCopyException(cause);
        if (v0 == null) {
            return exception;
        }
        void newException = v0;
        ArrayDeque<StackTraceElement> stacktrace = StackTraceRecoveryKt.createStackTrace(continuation2);
        if (stacktrace.isEmpty()) {
            return exception;
        }
        if (cause != exception) {
            StackTraceRecoveryKt.mergeRecoveredTraces(recoveredStacktrace, stacktrace);
        }
        return StackTraceRecoveryKt.createFinalException(cause, newException, stacktrace);
    }

    /*
     * WARNING - void declaration
     */
    private static final <E extends Throwable> E createFinalException(E cause, E result2, ArrayDeque<StackTraceElement> resultStackTrace) {
        int i2;
        resultStackTrace.addFirst(StackTraceRecoveryKt.artificialFrame("Coroutine boundary"));
        StackTraceElement[] causeTrace = cause.getStackTrace();
        Intrinsics.checkExpressionValueIsNotNull(causeTrace, "causeTrace");
        int size = StackTraceRecoveryKt.frameIndex(causeTrace, "kotlin.coroutines.jvm.internal.BaseContinuationImpl");
        if (size == -1) {
            void $this$toTypedArray$iv;
            Collection collection = resultStackTrace;
            E e = result2;
            boolean $i$f$toTypedArray = false;
            void v0 = $this$toTypedArray$iv;
            if (v0 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
            }
            void thisCollection$iv = v0;
            StackTraceElement[] stackTraceElementArray = thisCollection$iv.toArray(new StackTraceElement[0]);
            if (stackTraceElementArray == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            StackTraceElement[] stackTraceElementArray2 = stackTraceElementArray;
            e.setStackTrace(stackTraceElementArray2);
            return result2;
        }
        StackTraceElement[] mergedStackTrace = new StackTraceElement[resultStackTrace.size() + size];
        int $i$f$toTypedArray = 0;
        int thisCollection$iv = size;
        while ($i$f$toTypedArray < thisCollection$iv) {
            mergedStackTrace[i2] = causeTrace[i2];
            ++i2;
        }
        i2 = 0;
        Iterator iterator2 = ((Iterable)resultStackTrace).iterator();
        while (iterator2.hasNext()) {
            void index;
            StackTraceElement element;
            mergedStackTrace[size + index] = element = (StackTraceElement)iterator2.next();
            ++index;
        }
        result2.setStackTrace(mergedStackTrace);
        return result2;
    }

    private static final <E extends Throwable> Pair<E, StackTraceElement[]> causeAndStacktrace(@NotNull E $this$causeAndStacktrace) {
        Pair<Object, StackTraceElement[]> pair;
        Throwable cause = $this$causeAndStacktrace.getCause();
        if (cause != null && Intrinsics.areEqual(cause.getClass(), $this$causeAndStacktrace.getClass())) {
            boolean bl;
            StackTraceElement[] currentTrace;
            block5: {
                currentTrace = $this$causeAndStacktrace.getStackTrace();
                Intrinsics.checkExpressionValueIsNotNull(currentTrace, "currentTrace");
                StackTraceElement[] $this$any$iv = currentTrace;
                boolean $i$f$any = false;
                StackTraceElement[] stackTraceElementArray = $this$any$iv;
                int n = stackTraceElementArray.length;
                for (int j = 0; j < n; ++j) {
                    StackTraceElement element$iv;
                    StackTraceElement it = element$iv = stackTraceElementArray[j];
                    boolean bl2 = false;
                    StackTraceElement stackTraceElement = it;
                    Intrinsics.checkExpressionValueIsNotNull(stackTraceElement, "it");
                    if (!StackTraceRecoveryKt.isArtificial(stackTraceElement)) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
            if (bl) {
                pair = TuplesKt.to(cause, currentTrace);
            } else {
                E e = $this$causeAndStacktrace;
                StackTraceElement[] stackTraceElementArray = new StackTraceElement[]{};
                pair = TuplesKt.to(e, stackTraceElementArray);
            }
        } else {
            E e = $this$causeAndStacktrace;
            StackTraceElement[] stackTraceElementArray = new StackTraceElement[]{};
            pair = TuplesKt.to(e, stackTraceElementArray);
        }
        return pair;
    }

    /*
     * WARNING - void declaration
     */
    private static final void mergeRecoveredTraces(StackTraceElement[] recoveredStacktrace, ArrayDeque<StackTraceElement> result2) {
        int lastFrameIndex;
        int n;
        int n2;
        int $i$f$indexOfFirst;
        block5: {
            StackTraceElement[] $this$indexOfFirst$iv = recoveredStacktrace;
            $i$f$indexOfFirst = 0;
            n2 = 0;
            int n3 = $this$indexOfFirst$iv.length;
            while (n2 < n3) {
                void index$iv;
                StackTraceElement it = $this$indexOfFirst$iv[index$iv];
                boolean bl = false;
                if (StackTraceRecoveryKt.isArtificial(it)) {
                    n = index$iv;
                    break block5;
                }
                ++index$iv;
            }
            n = -1;
        }
        int startIndex = n + 1;
        $i$f$indexOfFirst = lastFrameIndex = recoveredStacktrace.length - 1;
        n2 = startIndex;
        if ($i$f$indexOfFirst >= n2) {
            while (true) {
                void i2;
                StackTraceElement element = recoveredStacktrace[i2];
                StackTraceElement stackTraceElement = result2.getLast();
                Intrinsics.checkExpressionValueIsNotNull(stackTraceElement, "result.last");
                if (StackTraceRecoveryKt.elementWiseEquals(element, stackTraceElement)) {
                    result2.removeLast();
                }
                result2.addFirst(recoveredStacktrace[i2]);
                if (i2 == n2) break;
                --i2;
            }
        }
    }

    @Nullable
    public static final Object recoverAndThrow(@NotNull Throwable exception, @NotNull Continuation<?> $completion) {
        int $i$f$recoverAndThrow = 0;
        if (StackTraceRecoveryKt.recoveryDisabled(exception)) {
            throw exception;
        }
        Continuation<?> it = $completion;
        boolean bl = false;
        if (!(it instanceof CoroutineStackFrame)) {
            throw exception;
        }
        throw StackTraceRecoveryKt.recoverFromStackFrame(exception, (CoroutineStackFrame)((Object)it));
    }

    @Nullable
    private static final Object recoverAndThrow$$forInline(@NotNull Throwable exception, @NotNull Continuation continuation2) {
        int $i$f$recoverAndThrow = 0;
        if (StackTraceRecoveryKt.recoveryDisabled(exception)) {
            throw exception;
        }
        InlineMarker.mark(0);
        Continuation it = continuation2;
        boolean bl = false;
        if (!(it instanceof CoroutineStackFrame)) {
            throw exception;
        }
        throw StackTraceRecoveryKt.recoverFromStackFrame(exception, (CoroutineStackFrame)((Object)it));
    }

    @NotNull
    public static final <E extends Throwable> E unwrap(@NotNull E exception) {
        boolean bl;
        Throwable cause;
        block4: {
            Intrinsics.checkParameterIsNotNull(exception, "exception");
            if (StackTraceRecoveryKt.recoveryDisabled(exception)) {
                return exception;
            }
            cause = exception.getCause();
            if (cause == null || Intrinsics.areEqual(cause.getClass(), exception.getClass()) ^ true) {
                return exception;
            }
            StackTraceElement[] stackTraceElementArray = exception.getStackTrace();
            Intrinsics.checkExpressionValueIsNotNull(stackTraceElementArray, "exception.stackTrace");
            StackTraceElement[] $this$any$iv = stackTraceElementArray;
            boolean $i$f$any = false;
            StackTraceElement[] stackTraceElementArray2 = $this$any$iv;
            int n = stackTraceElementArray2.length;
            for (int j = 0; j < n; ++j) {
                StackTraceElement element$iv;
                StackTraceElement it = element$iv = stackTraceElementArray2[j];
                boolean bl2 = false;
                StackTraceElement stackTraceElement = it;
                Intrinsics.checkExpressionValueIsNotNull(stackTraceElement, "it");
                if (!StackTraceRecoveryKt.isArtificial(stackTraceElement)) continue;
                bl = true;
                break block4;
            }
            bl = false;
        }
        if (bl) {
            return (E)cause;
        }
        return exception;
    }

    private static final <E extends Throwable> boolean recoveryDisabled(E exception) {
        return !DebugKt.getRECOVER_STACK_TRACES() || exception instanceof NonRecoverableThrowable;
    }

    private static final ArrayDeque<StackTraceElement> createStackTrace(CoroutineStackFrame continuation2) {
        boolean bl;
        ArrayDeque<StackTraceElement> stack = new ArrayDeque<StackTraceElement>();
        StackTraceElement stackTraceElement = continuation2.getStackTraceElement();
        if (stackTraceElement != null) {
            StackTraceElement stackTraceElement2 = stackTraceElement;
            boolean bl2 = false;
            bl = false;
            StackTraceElement it = stackTraceElement2;
            boolean bl3 = false;
            stack.add(it);
        }
        CoroutineStackFrame last2 = continuation2;
        while (true) {
            StackTraceElement stackTraceElement3;
            CoroutineStackFrame coroutineStackFrame;
            CoroutineStackFrame coroutineStackFrame2;
            if (!((coroutineStackFrame2 = last2) instanceof CoroutineStackFrame)) {
                coroutineStackFrame2 = coroutineStackFrame = null;
            }
            if (coroutineStackFrame2 == null || (coroutineStackFrame = coroutineStackFrame.getCallerFrame()) == null) {
                break;
            }
            last2 = coroutineStackFrame;
            if (last2.getStackTraceElement() == null) continue;
            bl = false;
            boolean bl4 = false;
            StackTraceElement it = stackTraceElement3;
            boolean bl5 = false;
            stack.add(it);
        }
        return stack;
    }

    @InternalCoroutinesApi
    @NotNull
    public static final StackTraceElement artificialFrame(@NotNull String message) {
        Intrinsics.checkParameterIsNotNull(message, "message");
        return new StackTraceElement("\b\b\b(" + message, "\b", "\b", -1);
    }

    public static final boolean isArtificial(@NotNull StackTraceElement $this$isArtificial) {
        Intrinsics.checkParameterIsNotNull($this$isArtificial, "$this$isArtificial");
        String string = $this$isArtificial.getClassName();
        Intrinsics.checkExpressionValueIsNotNull(string, "className");
        return StringsKt.startsWith$default(string, "\b\b\b", false, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    private static final int frameIndex(@NotNull StackTraceElement[] $this$frameIndex, String methodName) {
        int n;
        block2: {
            StackTraceElement[] $this$indexOfFirst$iv = $this$frameIndex;
            boolean $i$f$indexOfFirst = false;
            int n2 = 0;
            int n3 = $this$indexOfFirst$iv.length;
            while (n2 < n3) {
                void index$iv;
                StackTraceElement it = $this$indexOfFirst$iv[index$iv];
                boolean bl = false;
                if (Intrinsics.areEqual(methodName, it.getClassName())) {
                    n = index$iv;
                    break block2;
                }
                ++index$iv;
            }
            n = -1;
        }
        return n;
    }

    private static final boolean elementWiseEquals(@NotNull StackTraceElement $this$elementWiseEquals, StackTraceElement e) {
        return $this$elementWiseEquals.getLineNumber() == e.getLineNumber() && Intrinsics.areEqual($this$elementWiseEquals.getMethodName(), e.getMethodName()) && Intrinsics.areEqual($this$elementWiseEquals.getFileName(), e.getFileName()) && Intrinsics.areEqual($this$elementWiseEquals.getClassName(), e.getClassName());
    }

    public static /* synthetic */ void CoroutineStackFrame$annotations() {
    }

    public static /* synthetic */ void StackTraceElement$annotations() {
    }
}

